/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.collection.tanimoto;

import java.util.Set;
import java.util.stream.Collectors;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.collection.CollectionDataValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import ws.palladian.nodes.distances.collection.tanimoto.TanimotoCoefficientConfig;

final class TanimotoCoefficient
extends SingleColumnDistanceMeasure<TanimotoCoefficientConfig> {
    TanimotoCoefficient(TanimotoCoefficientConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        CollectionDataValue value1 = (CollectionDataValue)this.checkNotMissing(row1, this.getIndex(), CollectionDataValue.class);
        CollectionDataValue value2 = (CollectionDataValue)this.checkNotMissing(row2, this.getIndex(), CollectionDataValue.class);
        Set set1 = value1.stream().collect(Collectors.toSet());
        Set set2 = value2.stream().collect(Collectors.toSet());
        org.simmetrics.metrics.TanimotoCoefficient distance = new org.simmetrics.metrics.TanimotoCoefficient();
        return 1.0f - distance.compare(set1, set2);
    }
}

