/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.dameraulevenshtein;

import org.knime.base.util.flowvariable.FlowVariableProvider;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.util.CheckUtils;
import org.knime.distance.category.DistanceCategoryConfig;
import org.knime.distance.util.propertyresolver.Configuration;
import org.knime.distance.util.propertyresolver.Property;
import ws.palladian.nodes.distances.string.dameraulevenshtein.DamerauLevenshtein;
import ws.palladian.nodes.distances.string.dameraulevenshtein.DamerauLevenshteinFactory;

@Configuration
final class DamerauLevenshteinConfig
extends DistanceCategoryConfig<DamerauLevenshtein> {
    @Property(value="insert-delete")
    double insertDelete = 1.0;
    @Property(value="substitute")
    double substitute = 1.0;
    @Property(value="transpose")
    double transpose = 1.0;
    @Property(value="normalized")
    boolean normalized = false;

    DamerauLevenshteinConfig() {
        super(new String[0]);
    }

    DamerauLevenshteinConfig(double insertDelete, double substitute, double transpose, boolean normalized) {
        super(new String[0]);
        this.insertDelete = insertDelete;
        this.substitute = substitute;
        this.transpose = transpose;
        this.normalized = normalized;
    }

    private DamerauLevenshteinConfig(String column, double insertDelete, double substitute, double transpose, boolean normalized) {
        super(new String[]{column});
        this.insertDelete = insertDelete;
        this.substitute = substitute;
        this.transpose = transpose;
        this.normalized = normalized;
    }

    protected DistanceCategoryConfig<?> clone(String ... columns) throws InvalidSettingsException {
        CheckUtils.checkSetting((columns != null && columns.length == 1 ? 1 : 0) != 0, (String)"Exactly one column must be selected.", (Object[])new Object[0]);
        return new DamerauLevenshteinConfig(columns[0], this.insertDelete, this.substitute, this.transpose, this.normalized);
    }

    public DamerauLevenshtein createDistanceMeasure(DataTableSpec spec, FlowVariableProvider flowVariableProvider) throws InvalidSettingsException {
        return new DamerauLevenshtein(this, spec);
    }

    public String getFactoryId() {
        return DamerauLevenshteinFactory.ID;
    }
}

