/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.dameraulevenshtein;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.category.DistanceCategorySubPanel;
import ws.palladian.nodes.distances.string.dameraulevenshtein.DamerauLevenshteinConfig;

final class DamerauLevenshteinPanel
extends DistanceCategorySubPanel<DamerauLevenshteinConfig> {
    private static final long serialVersionUID = 1L;
    private final JSpinner insertDelete = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1000.0, 0.1));
    private final JSpinner substitute = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1000.0, 0.1));
    private final JSpinner transpose = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1000.0, 0.1));
    private final JCheckBox normalized = new JCheckBox("Normalize distance", false);

    DamerauLevenshteinPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.add(this.createPanel(), "West");
    }

    private Component createPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 2));
        panel.add(new JLabel("Cost of an insert or deletion operation:   "));
        panel.add(this.insertDelete);
        panel.add(new JLabel("Cost of a substitute operation:   "));
        panel.add(this.substitute);
        panel.add(new JLabel("Cost of a transpose operation:   "));
        panel.add(this.transpose);
        panel.add(this.normalized);
        return panel;
    }

    protected DamerauLevenshteinConfig getConfig() throws InvalidSettingsException {
        double insertDeleteValue = (Double)this.insertDelete.getValue();
        double substituteValue = (Double)this.substitute.getValue();
        double transposeValue = (Double)this.transpose.getValue();
        boolean normalizedValue = this.normalized.isSelected();
        return new DamerauLevenshteinConfig(insertDeleteValue, substituteValue, transposeValue, normalizedValue);
    }

    protected void loadConfig(DamerauLevenshteinConfig config) {
        DamerauLevenshteinConfig configNotNull = config == null ? new DamerauLevenshteinConfig() : config;
        this.insertDelete.setValue(configNotNull.insertDelete);
        this.substitute.setValue(configNotNull.substitute);
        this.transpose.setValue(configNotNull.transpose);
        this.normalized.setSelected(configNotNull.normalized);
    }
}

