/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.hamming;

import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import org.simmetrics.StringDistance;
import ws.palladian.nodes.distances.string.hamming.HammingDistanceConfig;

final class HammingDistance
extends SingleColumnDistanceMeasure<HammingDistanceConfig> {
    HammingDistance(HammingDistanceConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        String value1 = ((StringValue)this.checkNotMissing(row1, this.getIndex(), StringValue.class)).getStringValue();
        String value2 = ((StringValue)this.checkNotMissing(row2, this.getIndex(), StringValue.class)).getStringValue();
        if (value1.length() != value2.length()) {
            throw new DistanceMeasurementException(String.format("String a must have the same length as string b (%s vs %s)", value1.length(), value2.length()));
        }
        StringDistance hamming = org.simmetrics.metrics.HammingDistance.forString();
        return hamming.distance(value1, value2);
    }
}

