/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.smithwaterman;

import org.knime.base.util.flowvariable.FlowVariableProvider;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.util.CheckUtils;
import org.knime.distance.category.DistanceCategoryConfig;
import org.knime.distance.util.propertyresolver.Configuration;
import org.knime.distance.util.propertyresolver.Property;
import ws.palladian.nodes.distances.string.smithwaterman.SmithWaterman;
import ws.palladian.nodes.distances.string.smithwaterman.SmithWatermanFactory;

@Configuration
final class SmithWatermanConfig
extends DistanceCategoryConfig<SmithWaterman> {
    @Property(value="start-value")
    double startValue = -5.0;
    @Property(value="gap-value")
    double gapValue = -1.0;
    @Property(value="match-value")
    double matchValue = 5.0;
    @Property(value="mismatch-value")
    double mismatchValue = -3.0;
    @Property(value="window-size")
    int windowSize = Integer.MAX_VALUE;

    SmithWatermanConfig() {
        super(new String[0]);
    }

    SmithWatermanConfig(double startValue, double gapValue, double matchValue, double mismatchValue, int windowSize) {
        super(new String[0]);
        this.startValue = startValue;
        this.gapValue = gapValue;
        this.matchValue = matchValue;
        this.mismatchValue = mismatchValue;
        this.windowSize = windowSize;
    }

    private SmithWatermanConfig(String column, double startValue, double gapValue, double matchValue, double mismatchValue, int windowSize) {
        super(new String[]{column});
        this.startValue = startValue;
        this.gapValue = gapValue;
        this.matchValue = matchValue;
        this.mismatchValue = mismatchValue;
        this.windowSize = windowSize;
    }

    protected DistanceCategoryConfig<?> clone(String ... columns) throws InvalidSettingsException {
        CheckUtils.checkSetting((columns != null && columns.length == 1 ? 1 : 0) != 0, (String)"Exactly one column must be selected.", (Object[])new Object[0]);
        return new SmithWatermanConfig(columns[0], this.startValue, this.gapValue, this.matchValue, this.mismatchValue, this.windowSize);
    }

    public SmithWaterman createDistanceMeasure(DataTableSpec spec, FlowVariableProvider flowVariableProvider) throws InvalidSettingsException {
        return new SmithWaterman(this, spec);
    }

    public String getFactoryId() {
        return SmithWatermanFactory.ID;
    }
}

