/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.smithwaterman;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.category.DistanceCategorySubPanel;
import ws.palladian.nodes.distances.string.smithwaterman.SmithWatermanConfig;

final class SmithWatermanPanel
extends DistanceCategorySubPanel<SmithWatermanConfig> {
    private static final long serialVersionUID = 1L;
    private final JSpinner start = new JSpinner(new SpinnerNumberModel(-5.0, -1000.0, 0.0, 0.1));
    private final JSpinner gap = new JSpinner(new SpinnerNumberModel(-1.0, -1000.0, 0.0, 0.1));
    private final JSpinner match = new JSpinner(new SpinnerNumberModel(5.0, -1000.0, 1000.0, 0.1));
    private final JSpinner mismatch = new JSpinner(new SpinnerNumberModel(-3.0, -1000.0, 1000.0, 0.1));
    private final JSpinner window = new JSpinner(new SpinnerNumberModel(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, 1));

    SmithWatermanPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.add(this.createPanel(), "West");
    }

    private Component createPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 2));
        panel.add(new JLabel("Initial penalty for creating a gap:   "));
        panel.add(this.start);
        panel.add(new JLabel("Gap value:   "));
        panel.add(this.gap);
        panel.add(new JLabel("Score when characters are equal:   "));
        panel.add(this.match);
        panel.add(new JLabel("Score when characters are not equal:   "));
        panel.add(this.mismatch);
        panel.add(new JLabel("Window size:   "));
        panel.add(this.window);
        return panel;
    }

    protected SmithWatermanConfig getConfig() throws InvalidSettingsException {
        double startValue = (Double)this.start.getValue();
        double gapValue = (Double)this.gap.getValue();
        double matchValue = (Double)this.match.getValue();
        double mismatchValue = (Double)this.mismatch.getValue();
        int windowValue = (Integer)this.window.getValue();
        if (matchValue <= mismatchValue) {
            throw new InvalidSettingsException("The matchValue must be strictly greater then mismatchValue");
        }
        return new SmithWatermanConfig(startValue, gapValue, matchValue, mismatchValue, windowValue);
    }

    protected void loadConfig(SmithWatermanConfig config) {
        SmithWatermanConfig configNotNull = config == null ? new SmithWatermanConfig() : config;
        this.start.setValue(configNotNull.startValue);
        this.gap.setValue(configNotNull.gapValue);
        this.match.setValue(configNotNull.matchValue);
        this.mismatch.setValue(configNotNull.mismatchValue);
        this.window.setValue(configNotNull.windowSize);
    }
}

