/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.connector.db;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.context.NodeCreationConfiguration;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.maxmind.geoip2.connector.db.GeoIP2DBConnectorNodeSettings;
import ws.palladian.nodes.maxmind.geoip2.connector.db.GeoIP2DBConnectorPortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.port.AbstractGeoIP2ConnectorPortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.port.GeoIP2ConnectorPortObject;

class GeoIP2DBConnectorNodeModel
extends NodeModel {
    private final GeoIP2DBConnectorNodeSettings nodeSettings = new GeoIP2DBConnectorNodeSettings();

    protected GeoIP2DBConnectorNodeModel() {
        super(new PortType[0], new PortType[]{GeoIP2ConnectorPortObject.TYPE});
    }

    protected GeoIP2DBConnectorNodeModel(NodeCreationConfiguration creationConfig) {
        this();
        creationConfig.getURLConfig().ifPresent(urlConfig -> {
            try {
                String absolutePath = new File(urlConfig.getUrl().toURI()).getAbsolutePath();
                this.nodeSettings.getSettingDatabaseFile().setStringValue(absolutePath);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalStateException("Could not convert to absolute path: " + String.valueOf(urlConfig.getUrl()));
            }
        });
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        this.nodeSettings.validateSettings();
        return new PortObject[]{new GeoIP2ConnectorPortObject(this.createSpec())};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        this.nodeSettings.validateSettings();
        return new PortObjectSpec[]{this.createSpec()};
    }

    private AbstractGeoIP2ConnectorPortObjectSpec createSpec() {
        return new GeoIP2DBConnectorPortObjectSpec(this.nodeSettings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        GeoIP2DBConnectorNodeSettings temp = new GeoIP2DBConnectorNodeSettings();
        temp.loadSettingsFrom(settings);
        try {
            temp.validateSettings();
        }
        catch (InvalidSettingsException e) {
            this.setWarningMessage(e.getMessage());
        }
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

