/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.connector.downloader;

import java.util.Arrays;
import java.util.Objects;
import javax.swing.Icon;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.util.StringIconOption;
import ws.palladian.nodes.StringUtils;

class GeoIP2DBDownloaderNodeSettings {
    static final String KEY_DB = "db";
    static final String KEY_ACCOUNT_ID = "accountId";
    static final String KEY_LICENSE_KEY = "licenseKey";
    private final SettingsModelString db;
    private final SettingsModelString accountId;
    private final SettingsModelString licenseKey;

    GeoIP2DBDownloaderNodeSettings() {
        this.db = new SettingsModelString(KEY_DB, DownloadableMaxMindDb.CITY.label);
        this.accountId = new SettingsModelString(KEY_ACCOUNT_ID, null);
        this.licenseKey = new SettingsModelString(KEY_LICENSE_KEY, null);
    }

    public SettingsModelString getSettingDb() {
        return this.db;
    }

    public SettingsModelString getSettingAccountID() {
        return this.accountId;
    }

    public SettingsModelString getSettingLicenseKey() {
        return this.licenseKey;
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.db.saveSettingsTo(settings);
        this.accountId.saveSettingsTo(settings);
        this.licenseKey.saveSettingsTo(settings);
    }

    public void loadSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.db.loadSettingsFrom(settings);
        this.accountId.loadSettingsFrom(settings);
        this.licenseKey.loadSettingsFrom(settings);
    }

    public void validateSettings() throws InvalidSettingsException {
        String accountId = this.getSettingAccountID().getStringValue();
        if (StringUtils.nullOrEmpty((String)accountId)) {
            throw new InvalidSettingsException("Account ID is missing.");
        }
        try {
            Integer.parseInt(accountId);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidSettingsException("Account ID must only consist of digits.");
        }
        if (StringUtils.nullOrEmpty((String)this.getSettingLicenseKey().getStringValue())) {
            throw new InvalidSettingsException("License key is missing.");
        }
    }

    static enum DownloadableMaxMindDb implements StringIconOption
    {
        ASN("ASN", "https://download.maxmind.com/geoip/databases/GeoLite2-ASN/download?suffix=tar.gz"),
        CITY("City", "https://download.maxmind.com/geoip/databases/GeoLite2-City/download?suffix=tar.gz"),
        COUNTRY("Country", "https://download.maxmind.com/geoip/databases/GeoLite2-Country/download?suffix=tar.gz");

        final String label;
        final String downloadUrl;

        private DownloadableMaxMindDb(String label, String downloadUrl) {
            this.label = label;
            this.downloadUrl = downloadUrl;
        }

        public String getText() {
            return this.label;
        }

        public Icon getIcon() {
            return null;
        }

        static DownloadableMaxMindDb byLabel(String label) {
            Objects.requireNonNull(label);
            return Arrays.stream(DownloadableMaxMindDb.values()).filter(db -> db.label.equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such MaxMind DB " + label));
        }
    }
}

