/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.extractor.mapper;

import com.maxmind.geoip2.model.AbstractCityResponse;
import com.maxmind.geoip2.model.AbstractCountryResponse;
import com.maxmind.geoip2.model.AbstractResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Traits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.maxmind.geoip2.connector.port.ResponseType;
import ws.palladian.nodes.maxmind.geoip2.extractor.mapper.ResponseMapper;

class AbstractCountryResponseMapper
implements ResponseMapper {
    private static final EnumSet<ResponseType> SUPPORTED_TYPES = EnumSet.of(ResponseType.COUNTRY, ResponseType.CITY, ResponseType.INSIGHTS);
    private final ResponseType type;

    AbstractCountryResponseMapper(ResponseType type) {
        if (!SUPPORTED_TYPES.contains((Object)type)) {
            throw new IllegalArgumentException("This class only supports " + String.valueOf(SUPPORTED_TYPES) + ", not " + String.valueOf((Object)type));
        }
        this.type = type;
    }

    @Override
    public ResponseType getType() {
        return this.type;
    }

    @Override
    public List<? extends DataColumnSpec> getSpec() {
        ArrayList<Object> spec = new ArrayList<Object>();
        spec.add(new DataColumnSpecCreator("Continent Name", StringCell.TYPE).createSpec());
        spec.add(new DataColumnSpecCreator("Continent Code", StringCell.TYPE).createSpec());
        spec.add(new DataColumnSpecCreator("Continent GeoNames ID", LongCell.TYPE).createSpec());
        spec.addAll(AbstractCountryResponseMapper.createCountrySpec("Country "));
        if (this.type == ResponseType.INSIGHTS) {
            spec.add(new DataColumnSpecCreator("Country Confidence", IntCell.TYPE).createSpec());
        }
        spec.addAll(AbstractCountryResponseMapper.createCountrySpec("Registered Country "));
        spec.addAll(AbstractCountryResponseMapper.createCountrySpec("Represented Country "));
        spec.add(new DataColumnSpecCreator("Represented Country Type", StringCell.TYPE).createSpec());
        if (this.type == ResponseType.CITY || this.type == ResponseType.INSIGHTS) {
            spec.add(new DataColumnSpecCreator("City Name", StringCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("City GeoNames ID", LongCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("City Confidence", IntCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("City Accuracy Radius", IntCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("City Average Income", IntCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("City Coordinates", GeoCoordinateCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("City Metro Code", IntCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("City Population Density", IntCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("City Time Zone", StringCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Postal Code", StringCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Postal Confidence", IntCell.TYPE).createSpec());
        }
        spec.add(new DataColumnSpecCreator("Network", StringCell.TYPE).createSpec());
        if (this.type == ResponseType.CITY || this.type == ResponseType.INSIGHTS) {
            spec.add(new DataColumnSpecCreator("Autonomous System Number", LongCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Autonomous System Organization", StringCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Domain", StringCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("ISP", StringCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Organization", StringCell.TYPE).createSpec());
        }
        if (this.type == ResponseType.INSIGHTS) {
            spec.add(new DataColumnSpecCreator("Is Anonymous", BooleanCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Is Anonymous VPN", BooleanCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Is Hosting Provider", BooleanCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Is Public Proxy", BooleanCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Is Tor Exit Node", BooleanCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("Static IP Score", DoubleCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("User Count", IntCell.TYPE).createSpec());
            spec.add(new DataColumnSpecCreator("User Type", StringCell.TYPE).createSpec());
        }
        spec.add(new DataColumnSpecCreator("MaxMind Queries Remaining", IntCell.TYPE).createSpec());
        return Collections.unmodifiableList(spec);
    }

    private static List<? extends DataColumnSpec> createCountrySpec(String prefix) {
        ArrayList<DataColumnSpec> spec = new ArrayList<DataColumnSpec>();
        spec.add(new DataColumnSpecCreator(prefix + "Name", StringCell.TYPE).createSpec());
        spec.add(new DataColumnSpecCreator(prefix + "ISO Code", StringCell.TYPE).createSpec());
        spec.add(new DataColumnSpecCreator(prefix + "GeoNames ID", LongCell.TYPE).createSpec());
        spec.add(new DataColumnSpecCreator(prefix + "is in EU", BooleanCell.TYPE).createSpec());
        return spec;
    }

    @Override
    public List<? extends DataCell> map(AbstractResponse response) {
        AbstractCountryResponse countryResponse = (AbstractCountryResponse)response;
        ArrayList<Object> cells = new ArrayList<Object>();
        Continent continent = countryResponse.getContinent();
        cells.add(PalladianKnimeHelper.createStringCell((String)continent.getName()));
        cells.add(PalladianKnimeHelper.createStringCell((String)continent.getCode()));
        cells.add(PalladianKnimeHelper.createLongCell((Long)continent.getGeoNameId()));
        cells.addAll(AbstractCountryResponseMapper.mapCountry(countryResponse.getCountry()));
        if (this.type == ResponseType.INSIGHTS) {
            cells.add(PalladianKnimeHelper.createIntCell((Integer)countryResponse.getCountry().getConfidence()));
        }
        cells.addAll(AbstractCountryResponseMapper.mapCountry(countryResponse.getRegisteredCountry()));
        RepresentedCountry representedCountry = countryResponse.getRepresentedCountry();
        cells.addAll(AbstractCountryResponseMapper.mapCountry((Country)representedCountry));
        cells.add(PalladianKnimeHelper.createStringCell((String)representedCountry.getType()));
        if (this.type == ResponseType.CITY || this.type == ResponseType.INSIGHTS) {
            AbstractCityResponse cityResponse = (AbstractCityResponse)countryResponse;
            City city = cityResponse.getCity();
            cells.add(PalladianKnimeHelper.createStringCell((String)city.getName()));
            cells.add(PalladianKnimeHelper.createLongCell((Long)city.getGeoNameId()));
            cells.add(PalladianKnimeHelper.createIntCell((Integer)city.getConfidence()));
            Location location = cityResponse.getLocation();
            cells.add(PalladianKnimeHelper.createIntCell((Integer)location.getAccuracyRadius()));
            cells.add(PalladianKnimeHelper.createIntCell((Integer)location.getAverageIncome()));
            Double lat = location.getLatitude();
            Double lng = location.getLongitude();
            cells.add(lat != null && lng != null ? new GeoCoordinateCell(lat.doubleValue(), lng.doubleValue()) : DataType.getMissingCell());
            cells.add(PalladianKnimeHelper.createIntCell((Integer)location.getMetroCode()));
            cells.add(PalladianKnimeHelper.createIntCell((Integer)location.getPopulationDensity()));
            cells.add(PalladianKnimeHelper.createStringCell((String)location.getTimeZone()));
            Postal postal = cityResponse.getPostal();
            cells.add(PalladianKnimeHelper.createStringCell((String)postal.getCode()));
            cells.add(PalladianKnimeHelper.createIntCell((Integer)postal.getConfidence()));
        }
        Traits traits = countryResponse.getTraits();
        cells.add(PalladianKnimeHelper.createStringCell((String)traits.getNetwork().toString()));
        if (this.type == ResponseType.CITY || this.type == ResponseType.INSIGHTS) {
            cells.add(PalladianKnimeHelper.createLongCell((Long)traits.getAutonomousSystemNumber()));
            cells.add(PalladianKnimeHelper.createStringCell((String)traits.getAutonomousSystemOrganization()));
            cells.add(PalladianKnimeHelper.createStringCell((String)traits.getDomain()));
            cells.add(PalladianKnimeHelper.createStringCell((String)traits.getIsp()));
            cells.add(PalladianKnimeHelper.createStringCell((String)traits.getOrganization()));
        }
        if (this.type == ResponseType.INSIGHTS) {
            cells.add(BooleanCell.BooleanCellFactory.create((boolean)traits.isAnonymous()));
            cells.add(BooleanCell.BooleanCellFactory.create((boolean)traits.isAnonymousVpn()));
            cells.add(BooleanCell.BooleanCellFactory.create((boolean)traits.isHostingProvider()));
            cells.add(BooleanCell.BooleanCellFactory.create((boolean)traits.isPublicProxy()));
            cells.add(BooleanCell.BooleanCellFactory.create((boolean)traits.isTorExitNode()));
            cells.add(PalladianKnimeHelper.createDoubleCell((Double)traits.getStaticIpScore()));
            cells.add(PalladianKnimeHelper.createIntCell((Integer)traits.getUserCount()));
            cells.add(PalladianKnimeHelper.createStringCell((String)traits.getUserType()));
        }
        cells.add(PalladianKnimeHelper.createIntCell((Integer)countryResponse.getMaxMind().getQueriesRemaining()));
        return Collections.unmodifiableList(cells);
    }

    private static List<? extends DataCell> mapCountry(Country country) {
        ArrayList<DataCell> cells = new ArrayList<DataCell>();
        cells.add(PalladianKnimeHelper.createStringCell((String)country.getName()));
        cells.add(PalladianKnimeHelper.createStringCell((String)country.getIsoCode()));
        cells.add(PalladianKnimeHelper.createLongCell((Long)country.getGeoNameId()));
        cells.add(BooleanCell.BooleanCellFactory.create((boolean)country.isInEuropeanUnion()));
        return cells;
    }
}

