/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.extractor.mapper;

import com.maxmind.geoip2.model.AbstractResponse;
import com.maxmind.geoip2.model.AsnResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.maxmind.geoip2.connector.port.ResponseType;
import ws.palladian.nodes.maxmind.geoip2.extractor.mapper.ResponseMapper;

final class AsnResponseMapper
implements ResponseMapper {
    AsnResponseMapper() {
    }

    @Override
    public ResponseType getType() {
        return ResponseType.ASN;
    }

    @Override
    public List<? extends DataColumnSpec> getSpec() {
        ArrayList<DataColumnSpec> spec = new ArrayList<DataColumnSpec>();
        spec.add(new DataColumnSpecCreator("Network", StringCell.TYPE).createSpec());
        spec.add(new DataColumnSpecCreator("Autonomous System Number", LongCell.TYPE).createSpec());
        spec.add(new DataColumnSpecCreator("Autonomous System Organization", StringCell.TYPE).createSpec());
        return Collections.unmodifiableList(spec);
    }

    @Override
    public List<? extends DataCell> map(AbstractResponse response) {
        AsnResponse asnResponse = (AsnResponse)response;
        ArrayList<DataCell> cells = new ArrayList<DataCell>();
        cells.add(PalladianKnimeHelper.createStringCell((String)asnResponse.getNetwork().toString()));
        cells.add(PalladianKnimeHelper.createLongCell((Long)asnResponse.getAutonomousSystemNumber()));
        cells.add(PalladianKnimeHelper.createStringCell((String)asnResponse.getAutonomousSystemOrganization()));
        return Collections.unmodifiableList(cells);
    }
}

