/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.phone;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.geocoding.PhoneNumberOfflineGeocoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.phone.PhoneNumberFormatterNodeSettings;

class PhoneNumberFormatterNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final PhoneNumberFormatterNodeSettings nodeSettings = new PhoneNumberFormatterNodeSettings();

    PhoneNumberFormatterNodeModel() {
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        final int inputColIdx = spec.findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        final ArrayList<DataColumnSpec> appendedSpec = new ArrayList<DataColumnSpec>();
        appendedSpec.add(new DataColumnSpecCreator("Valid", BooleanCell.TYPE).createSpec());
        appendedSpec.add(new DataColumnSpecCreator("Formatted", StringCell.TYPE).createSpec());
        appendedSpec.add(new DataColumnSpecCreator("Region", StringCell.TYPE).createSpec());
        appendedSpec.add(new DataColumnSpecCreator("Country", StringCell.TYPE).createSpec());
        appendedSpec.add(new DataColumnSpecCreator("Number Type", StringCell.TYPE).createSpec());
        final String defaultRegion = this.nodeSettings.defaultRegion.getStringValue();
        Object outputColumnPrefix = this.nodeSettings.outputColumnPrefix.getStringValue();
        if (StringUtils.nullOrEmpty((String)outputColumnPrefix)) {
            outputColumnPrefix = this.nodeSettings.inputColumn.getStringValue() + ": ";
        }
        DataColumnSpec[] specArray = (DataColumnSpec[])PhoneNumberFormatterNodeModel.prefix(appendedSpec, (String)outputColumnPrefix).toArray(DataColumnSpec[]::new);
        AbstractCellFactory factory = new AbstractCellFactory(true, specArray){

            public DataCell[] getCells(DataRow row) {
                List<Object> cells = new ArrayList();
                DataCell inputCell = row.getCell(inputColIdx);
                if (inputCell.isMissing()) {
                    cells = Collections.nCopies(appendedSpec.size(), DataType.getMissingCell());
                } else {
                    String stringValue = ((StringValue)inputCell).getStringValue();
                    PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
                    try {
                        Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse((CharSequence)stringValue, defaultRegion);
                        cells.add(BooleanCell.BooleanCellFactory.create((boolean)phoneNumberUtil.isValidNumber(phoneNumber)));
                        PhoneNumberUtil.PhoneNumberFormat format = PhoneNumberUtil.PhoneNumberFormat.valueOf((String)PhoneNumberFormatterNodeModel.this.nodeSettings.phoneNumberFormat.getStringValue());
                        String formattedNumber = phoneNumberUtil.format(phoneNumber, format);
                        cells.add(new StringCell(formattedNumber));
                        PhoneNumberOfflineGeocoder geocoder = PhoneNumberOfflineGeocoder.getInstance();
                        LinkedHashSet<String> geocodes = new LinkedHashSet<String>();
                        geocodes.add(geocoder.getDescriptionForNumber(phoneNumber, Locale.ROOT));
                        geocodes.add(geocoder.getDescriptionForNumber(phoneNumber, Locale.ROOT, "ZZ"));
                        String region = String.join((CharSequence)", ", geocodes);
                        cells.add(region.isEmpty() ? DataType.getMissingCell() : new StringCell(region));
                        String country = phoneNumberUtil.getRegionCodeForNumber(phoneNumber);
                        cells.add(PalladianKnimeHelper.createStringCell((String)country));
                        cells.add(new StringCell(phoneNumberUtil.getNumberType(phoneNumber).toString()));
                    }
                    catch (NumberParseException numberParseException) {
                        cells = Collections.nCopies(appendedSpec.size(), DataType.getMissingCell());
                    }
                }
                return (DataCell[])cells.toArray(DataCell[]::new);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        int inputColIdx = inSpecs[0].findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        if (inputColIdx < 0) {
            throw new InvalidSettingsException("Please select a valid input column.");
        }
        if (StringUtils.nullOrEmpty((String)this.nodeSettings.defaultRegion.getStringValue())) {
            throw new InvalidSettingsException("Please select a default region.");
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    private static List<? extends DataColumnSpec> prefix(List<? extends DataColumnSpec> specList, String prefix) {
        return specList.stream().map(spec -> {
            String prefixedName = Optional.ofNullable(prefix).orElse("") + spec.getName();
            DataColumnSpecCreator specCreator = new DataColumnSpecCreator(spec);
            specCreator.setName(prefixedName);
            return specCreator.createSpec();
        }).collect(Collectors.toList());
    }
}

