/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.knime.core.node.NodeLogger;
import ws.palladian.nodes.oauth.OAuthFlow;

public final class LocalOAuthServer {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(LocalOAuthServer.class);
    private static final Map<Integer, LocalOAuthServer> INSTANCES = new HashMap<Integer, LocalOAuthServer>();
    private final Server server;
    private final int port;
    private final OAuthFlow flow;
    private BiConsumer<String, Exception> statusUpdateConsumer = (message, exception) -> {};
    private Consumer<OAuthFlow.OAuthData> tokenConsumer = token -> {};

    private LocalOAuthServer(Server server, int port, OAuthFlow flow) {
        this.server = server;
        this.port = port;
        this.flow = flow;
    }

    public static synchronized LocalOAuthServer start(int port, final OAuthFlow flow) throws Exception {
        if (INSTANCES.containsKey(port)) {
            throw new IllegalStateException("There is already a server running on port " + port);
        }
        Server server = new Server(port);
        final LocalOAuthServer instance = new LocalOAuthServer(server, port, flow);
        INSTANCES.put(port, instance);
        server.setHandler((Handler)new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                LOGGER.debugWithFormat(request.toString(), new Object[0]);
                if (flow.validCallbackResponse(request)) {
                    instance.receivedCode(request);
                    response.setStatus(200);
                    response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/html;charset=utf-8");
                    Content.Sink.write((Content.Sink)response, (boolean)true, (String)LocalOAuthServer.getAccessGrantedHtml(), (Callback)callback);
                } else if (!request.getHttpURI().getPath().equals("/") || !request.getHttpURI().getQuery().contains("error=")) {
                    response.setStatus(404);
                }
                return true;
            }
        });
        server.start();
        return instance;
    }

    public void stop() {
        try {
            if (this.server.isRunning()) {
                this.statusUpdateConsumer.accept("Stopping running server", null);
                this.server.stop();
            }
            INSTANCES.remove(this.port);
        }
        catch (Exception e) {
            this.statusUpdateConsumer.accept("Error: Could not stop running server", e);
        }
    }

    private static String getAccessGrantedHtml() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(LocalOAuthServer.class.getResourceAsStream("AccessGranted.html"), StandardCharsets.UTF_8));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void receivedCode(Request request) {
        this.statusUpdateConsumer.accept("Received authorization", null);
        try {
            OAuthFlow.OAuthData oauthToken = this.flow.extractToken(request);
            this.tokenConsumer.accept(oauthToken);
        }
        catch (Exception e) {
            this.statusUpdateConsumer.accept("Could not get access token: " + e.getMessage(), e);
        }
    }

    public void onUpdateStatus(BiConsumer<String, Exception> statusUpdateConsumer) {
        this.statusUpdateConsumer = Objects.requireNonNull(statusUpdateConsumer);
    }

    public void onReceivedCode(Consumer<OAuthFlow.OAuthData> tokenConsumer) {
        this.tokenConsumer = Objects.requireNonNull(tokenConsumer);
    }
}

