/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth;

import com.github.scribejava.core.builder.ServiceBuilderCommon;
import com.github.scribejava.core.builder.ServiceBuilderOAuth10a;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.oauth.OAuth10aService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.eclipse.jetty.server.Request;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.workflow.FlowVariable;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.oauth.OAuthApiFactoryRegistry;
import ws.palladian.nodes.oauth.OAuthFlow;
import ws.palladian.nodes.oauth.OAuthNodeSettings;

class OAuth10aFlow
extends OAuthFlow {
    private static final String CFGKEY_ACCESS_TOKEN_SECRET = "accessTokenSecret";
    private final OAuth10aService service;
    private OAuth1RequestToken requestToken;

    private OAuth10aFlow(OAuth10aService service) {
        this.service = service;
    }

    @Override
    public String getBrowserUrl() throws Exception {
        this.requestToken = this.service.getRequestToken();
        return this.service.getAuthorizationUrl(this.requestToken);
    }

    @Override
    public boolean validCallbackResponse(Request request) {
        return request.getHttpURI().getPath().equals("/") && request.getHttpURI().getQuery() != null && request.getHttpURI().getQuery().contains("oauth_token=");
    }

    @Override
    public void saveToken(Request request, OAuthNodeSettings nodeSettings) throws Exception {
        Map<String, String> params = OAuth10aFlow.parseQueryParams(request.getHttpURI().getQuery());
        String verifier = params.get("oauth_verifier");
        OAuth1AccessToken accessToken = this.service.getAccessToken(this.requestToken, verifier);
        nodeSettings.accessToken.setStringValue(accessToken.getToken());
        nodeSettings.accessTokenSecret.setStringValue(accessToken.getTokenSecret());
    }

    @Override
    public OAuthFlow.OAuthData extractToken(Request request) throws Exception {
        Map<String, String> params = OAuth10aFlow.parseQueryParams(request.getHttpURI().getQuery());
        String verifier = params.get("oauth_verifier");
        OAuth1AccessToken accessToken = this.service.getAccessToken(this.requestToken, verifier);
        return new OAuth10aData(accessToken.getToken(), accessToken.getTokenSecret(), accessToken.getRawResponse());
    }

    public static final class OAuth10aApi
    extends OAuthApiFactoryRegistry.OAuthAPI {
        private final DefaultApi10a api;

        OAuth10aApi(String name, Icon icon, DefaultApi10a api, String websiteUrl, boolean deprecated) {
            super(name, icon, websiteUrl, deprecated);
            this.api = api;
        }

        @Override
        public OAuthFlow createFlow(ServiceBuilderCommon serviceBuilder) {
            return new OAuth10aFlow(((ServiceBuilderOAuth10a)serviceBuilder).build(this.api));
        }

        @Override
        public DataTableSpec getSpec() {
            return new DataTableSpecCreator().addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("accessToken", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(OAuth10aFlow.CFGKEY_ACCESS_TOKEN_SECRET, StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("rawResponse", StringCell.TYPE).createSpec()}).createSpec();
        }

        @Override
        public OAuthFlow.OAuthData loadSettings(ServiceBuilderCommon serviceBuilder, NodeSettingsRO tokenSettings) throws InvalidSettingsException {
            String accessToken = tokenSettings.getString("accessToken");
            String accessTokenSecret = tokenSettings.getString(OAuth10aFlow.CFGKEY_ACCESS_TOKEN_SECRET);
            String rawResponse = tokenSettings.getString("rawResponse");
            return new OAuth10aData(accessToken, accessTokenSecret, rawResponse);
        }

        @Override
        public String getIdentifier() {
            return this.api.getClass().getName();
        }
    }

    public static class OAuth10aData
    implements OAuthFlow.OAuthData {
        private final String accessToken;
        private final String accessTokenSecret;
        private final String rawResponse;

        private OAuth10aData(String accessToken, String accessTokenSecret, String rawResponse) {
            this.accessToken = accessToken;
            this.accessTokenSecret = accessTokenSecret;
            this.rawResponse = rawResponse;
        }

        @Override
        public List<DataCell> getCells() {
            ArrayList<DataCell> cells = new ArrayList<DataCell>();
            cells.add(PalladianKnimeHelper.createStringCell((String)this.accessToken));
            cells.add(PalladianKnimeHelper.createStringCell((String)this.accessTokenSecret));
            cells.add(PalladianKnimeHelper.createStringCell((String)this.rawResponse));
            return cells;
        }

        @Override
        public List<FlowVariable> getFlowVariables() {
            ArrayList<FlowVariable> variables = new ArrayList<FlowVariable>();
            variables.add(new FlowVariable("accessToken", this.accessToken));
            variables.add(new FlowVariable(OAuth10aFlow.CFGKEY_ACCESS_TOKEN_SECRET, this.accessTokenSecret));
            return variables;
        }

        @Override
        public OAuthFlow.OAuthData refreshToken() throws Exception {
            return this;
        }

        @Override
        public void saveSettings(NodeSettingsWO tokenSettings) {
            tokenSettings.addString("accessToken", this.accessToken);
            tokenSettings.addString(OAuth10aFlow.CFGKEY_ACCESS_TOKEN_SECRET, this.accessTokenSecret);
            tokenSettings.addString("rawResponse", this.rawResponse);
        }

        @Override
        public boolean needsRefresh() {
            return false;
        }
    }
}

