/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.ServiceBuilderCommon;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.StringIconOption;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.oauth.LogOutputStream;
import ws.palladian.nodes.oauth.OAuthApiFactoryRegistry;
import ws.palladian.nodes.oauth.OAuthFlow;
import ws.palladian.nodes.oauth.OAuthNodeSettings;

@Deprecated
class OAuthNodeDialog
extends DefaultNodeSettingsPane {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(OAuthNodeDialog.class);
    private static final int PORT = 55931;
    private static final String REDIRECT_URI = "http://localhost:55931";
    private static Server server;
    private final OAuthNodeSettings nodeSettings = new OAuthNodeSettings();
    private final DialogComponentLabel accessTokenLabel;
    private OAuthFlow flow;

    OAuthNodeDialog() {
        StringIconOption[] options = (StringIconOption[])OAuthApiFactoryRegistry.getApis().toArray(StringIconOption[]::new);
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.nodeSettings.service, "Service", options));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.apiKey, "API Key"));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.apiSecret, "API Secret"));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.defaultScope, "Scope"));
        this.accessTokenLabel = new DialogComponentLabel("");
        this.addDialogComponent((DialogComponent)this.accessTokenLabel);
        DialogComponentButton accessTokenButton = new DialogComponentButton("Authorize Access");
        this.addDialogComponent((DialogComponent)accessTokenButton);
        accessTokenButton.addActionListener(e -> {
            ServiceBuilder serviceBuilder = new ServiceBuilder(this.nodeSettings.apiKey.getStringValue()).apiSecret(this.nodeSettings.apiSecret.getStringValue()).callback(REDIRECT_URI).debugStream((OutputStream)new LogOutputStream(LOGGER));
            if (StringUtils.notNullOrEmpty((String)this.nodeSettings.defaultScope.getStringValue())) {
                serviceBuilder = serviceBuilder.defaultScope(this.nodeSettings.defaultScope.getStringValue());
            }
            this.flow = OAuthApiFactoryRegistry.getAPI(this.nodeSettings.service.getStringValue()).createFlow((ServiceBuilderCommon)serviceBuilder);
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        OAuthNodeDialog.this.startServerIfNotYetRunning();
                    }
                    catch (Exception e) {
                        OAuthNodeDialog.this.updateStatus("Could not start HTTP server on port 55931: " + e.getMessage(), e);
                        return null;
                    }
                    Desktop.getDesktop().browse(new URI(OAuthNodeDialog.this.flow.getBrowserUrl()));
                    OAuthNodeDialog.this.updateStatus("Waiting for authorization \u2013 please check your browser.", null);
                    return null;
                }
            }.execute();
        });
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        try {
            this.nodeSettings.accessToken.loadSettingsFrom(settings);
            if (this.nodeSettings.accessToken.getStringValue() != null) {
                this.accessTokenLabel.setText("Access token: " + this.nodeSettings.accessToken.getStringValue());
            } else {
                this.accessTokenLabel.setText("Click the button to request an access token.");
            }
        }
        catch (InvalidSettingsException e) {
            LOGGER.debug((Object)"Encountered ISE", (Throwable)e);
        }
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.saveSettingsTo(settings);
    }

    public void onClose() {
        this.stopServerIfRunning();
    }

    private void startServerIfNotYetRunning() throws Exception {
        if (server != null && server.isRunning()) {
            LOGGER.debug((Object)"Server is already running");
            return;
        }
        server = new Server(55931);
        server.setHandler((Handler)new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                LOGGER.debugWithFormat(request.toString(), new Object[0]);
                if (OAuthNodeDialog.this.flow.validCallbackResponse(request)) {
                    OAuthNodeDialog.this.receivedCode(request);
                    response.setStatus(200);
                    response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/html;charset=utf-8");
                    Content.Sink.write((Content.Sink)response, (boolean)true, (String)OAuthNodeDialog.getAccessGrantedHtml(), (Callback)callback);
                } else if (!request.getHttpURI().getPath().equals("/") || !request.getHttpURI().getQuery().contains("error=")) {
                    response.setStatus(404);
                }
                return true;
            }
        });
        this.updateStatus("Starting HTTP server on 55931", null);
        server.start();
    }

    private void stopServerIfRunning() {
        if (server != null && server.isRunning()) {
            try {
                this.updateStatus("Stopping running server", null);
                server.stop();
                server = null;
            }
            catch (Exception e) {
                this.updateStatus("Error: Could not stop running server", e);
            }
        }
    }

    private void updateStatus(String message, Exception ex) {
        this.accessTokenLabel.setText(message);
        if (ex != null) {
            LOGGER.error((Object)message, (Throwable)ex);
        } else {
            LOGGER.info((Object)message);
        }
    }

    private void receivedCode(Request request) {
        this.updateStatus("Received authorization", null);
        try {
            this.flow.saveToken(request, this.nodeSettings);
            this.updateStatus("Access token: " + this.nodeSettings.accessToken.getStringValue(), null);
        }
        catch (Exception e) {
            this.updateStatus("Could not get access token: " + e.getMessage(), e);
        }
    }

    private static String getAccessGrantedHtml() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(OAuthNodeDialog.class.getResourceAsStream("AccessGranted.html"), StandardCharsets.UTF_8));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

