/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth.v2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.net.URI;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.text.StringEscapeUtils;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.StringIconOption;
import org.knime.core.node.workflow.VariableType;
import ws.palladian.nodes.oauth.LocalOAuthServer;
import ws.palladian.nodes.oauth.OAuthApiFactoryRegistry;
import ws.palladian.nodes.oauth.OAuthFlow;
import ws.palladian.nodes.oauth.v2.OAuthNode2Settings;

class OAuthNode2Dialog
extends DefaultNodeSettingsPane {
    static final NodeLogger LOGGER = NodeLogger.getLogger(OAuthNode2Dialog.class);
    private static final int PORT = 55931;
    static final String REDIRECT_URI = "http://localhost:55931";
    private LocalOAuthServer oAuthServer;
    private final OAuthNode2Settings nodeSettings = new OAuthNode2Settings();
    private final DialogComponentStringSelection serviceSelection;
    private final DialogComponentButton authorizeButton;
    private final DialogComponentButton clearButton;
    private final DialogComponentString apiKeyComponent;
    private final DialogComponentString apiSecretComponent;
    private final DialogComponentString scopeComponent;
    private final DialogComponentLabel messageLabel;
    final FlowVariableModel serviceFv = this.createFlowVariableModel("service", (VariableType)VariableType.StringType.INSTANCE);
    final FlowVariableModel apiKeyFv = this.createFlowVariableModel("apiKey", (VariableType)VariableType.StringType.INSTANCE);
    final FlowVariableModel apiSecretFv = this.createFlowVariableModel("apiSecret", (VariableType)VariableType.StringType.INSTANCE);
    final FlowVariableModel scopeFv = this.createFlowVariableModel("defaultScope", (VariableType)VariableType.StringType.INSTANCE);

    OAuthNode2Dialog() {
        StringIconOption[] options = (StringIconOption[])OAuthApiFactoryRegistry.getApis(true).stream().map(oAuthAPI -> new OAuthOption((OAuthApiFactoryRegistry.OAuthAPI)oAuthAPI)).toArray(StringIconOption[]::new);
        this.serviceSelection = new DialogComponentStringSelection(this.nodeSettings.service, "Service", options, this.serviceFv);
        JComboBox comboBox = (JComboBox)this.serviceSelection.getComponentPanel().getComponent(1);
        comboBox.setRenderer(new OAuthRenderer());
        this.addDialogComponent((DialogComponent)this.serviceSelection);
        this.apiKeyComponent = new DialogComponentString(this.nodeSettings.apiKey, "API Key", false, 30, this.apiKeyFv);
        this.addDialogComponent((DialogComponent)this.apiKeyComponent);
        this.apiSecretComponent = new DialogComponentString(this.nodeSettings.apiSecret, "API Secret", false, 30, this.apiSecretFv);
        this.addDialogComponent((DialogComponent)this.apiSecretComponent);
        this.scopeComponent = new DialogComponentString(this.nodeSettings.defaultScope, "Scope", false, 30, this.scopeFv);
        this.addDialogComponent((DialogComponent)this.scopeComponent);
        this.messageLabel = new DialogComponentLabel("");
        this.addDialogComponent((DialogComponent)this.messageLabel);
        this.setHorizontalPlacement(true);
        this.authorizeButton = new DialogComponentButton("Authorize Access");
        this.addDialogComponent((DialogComponent)this.authorizeButton);
        this.authorizeButton.addActionListener(e -> {
            String browserUrl;
            OAuthNode2Settings nodeSettingsCopyWithFV = this.nodeSettings.createForDialog(this);
            try {
                nodeSettingsCopyWithFV.validateSettingsForAuth();
            }
            catch (InvalidSettingsException ex) {
                JOptionPane.showMessageDialog(this.getPanel(), ex.getMessage(), null, 0);
                return;
            }
            final OAuthFlow flow = nodeSettingsCopyWithFV.createFlow();
            try {
                browserUrl = flow.getBrowserUrl();
            }
            catch (Exception ex) {
                String msg = "<html><body><p style='width:300px'>" + StringEscapeUtils.escapeHtml4((String)ex.getMessage()) + "</p></body></html>";
                JOptionPane.showMessageDialog(this.getPanel(), msg, null, 0);
                return;
            }
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        OAuthNode2Dialog.this.updateStatus("Starting HTTP server on 55931", null);
                        OAuthNode2Dialog.this.oAuthServer = LocalOAuthServer.start(55931, flow);
                        OAuthNode2Dialog.this.oAuthServer.onUpdateStatus((message, exception) -> OAuthNode2Dialog.this.updateStatus((String)message, (Exception)exception));
                        OAuthNode2Dialog.this.oAuthServer.onReceivedCode(token -> {
                            OAuthNode2Dialog.this.nodeSettings.setOAuthToken((OAuthFlow.OAuthData)token);
                            OAuthNode2Dialog.this.updateComponentsAndMessageLabel();
                        });
                    }
                    catch (Exception e) {
                        OAuthNode2Dialog.this.updateStatus("Could not start HTTP server on port 55931: " + e.getMessage(), e);
                        return null;
                    }
                    Desktop.getDesktop().browse(new URI(browserUrl));
                    OAuthNode2Dialog.this.updateStatus("Waiting for authorization \u2013 please check your browser.", null);
                    return null;
                }
            }.execute();
        });
        this.clearButton = new DialogComponentButton("Clear Token");
        this.addDialogComponent((DialogComponent)this.clearButton);
        this.clearButton.addActionListener(e -> {
            this.nodeSettings.setOAuthToken(null);
            this.updateComponentsAndMessageLabel();
        });
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        try {
            this.nodeSettings.loadValidatedSettingsFrom(settings);
            this.updateComponentsAndMessageLabel();
        }
        catch (InvalidSettingsException e) {
            LOGGER.debug((Object)"Encountered ISE", (Throwable)e);
        }
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.saveSettingsTo(settings);
    }

    public void onClose() {
        if (this.oAuthServer != null) {
            this.oAuthServer.stop();
        }
    }

    private void updateComponentsAndMessageLabel() {
        boolean hasToken = this.nodeSettings.getOAuthToken() != null;
        OAuthNode2Dialog.enableOrDisableComponent((DialogComponent)this.serviceSelection, !hasToken);
        OAuthNode2Dialog.enableOrDisableComponent((DialogComponent)this.apiKeyComponent, !hasToken);
        OAuthNode2Dialog.enableOrDisableComponent((DialogComponent)this.apiSecretComponent, !hasToken);
        OAuthNode2Dialog.enableOrDisableComponent((DialogComponent)this.scopeComponent, !hasToken);
        OAuthNode2Dialog.enableOrDisableComponent((DialogComponent)this.authorizeButton, !hasToken);
        OAuthNode2Dialog.enableOrDisableComponent((DialogComponent)this.clearButton, hasToken);
        if (hasToken) {
            this.updateStatus("Successfully received an access token.", null);
        } else {
            this.updateStatus("Click the button to request an access token.", null);
        }
    }

    private static void enableOrDisableComponent(DialogComponent component, boolean state) {
        Arrays.stream(component.getComponentPanel().getComponents()).forEach(c -> c.setEnabled(state));
    }

    private void updateStatus(String message, Exception ex) {
        this.messageLabel.setText(message);
        JLabel jLabel = (JLabel)this.messageLabel.getComponentPanel().getComponent(0);
        if (ex != null) {
            jLabel.setForeground(Color.RED);
            LOGGER.error((Object)message, (Throwable)ex);
        } else {
            jLabel.setForeground(Color.BLACK);
            LOGGER.info((Object)message);
        }
    }

    private static final class OAuthOption
    implements StringIconOption {
        final OAuthApiFactoryRegistry.OAuthAPI api;

        private OAuthOption(OAuthApiFactoryRegistry.OAuthAPI api) {
            this.api = api;
        }

        public String getText() {
            return this.api.getIdentifier();
        }

        public Icon getIcon() {
            return this.api.getIcon();
        }
    }

    private static final class OAuthRenderer
    extends DefaultListCellRenderer {
        private OAuthRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            OAuthOption stringIconOption = (OAuthOption)value;
            if (stringIconOption != null) {
                this.setText(stringIconOption.api.getNameForUI());
                this.setIcon(stringIconOption.getIcon());
            }
            return component;
        }
    }
}

