/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.licensing.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;

public final class Utils {
    static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final TimeZone TIME_ZONE_GMT = TimeZone.getTimeZone("GMT");

    public static String formatDate(Date date) {
        Objects.requireNonNull(date, "date must not be null");
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(date);
    }

    public static Date parseDate(String dateString) {
        Objects.requireNonNull(dateString, "dateString must not be null");
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            dateFormat.setTimeZone(TIME_ZONE_GMT);
            return dateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("\"" + dateString + "\" could not be parsed.");
        }
    }

    public static Date getToday() {
        GregorianCalendar calendar = new GregorianCalendar(TIME_ZONE_GMT);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private Utils() {
    }
}

