/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.regextractor;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class MultiSelectBox<V>
extends JButton {
    private final List<ChangeListener> selectionChangeListeners = new ArrayList<ChangeListener>();
    private final List<JCheckBoxMenuItem> menuItems = new ArrayList<JCheckBoxMenuItem>();
    private final JPopupMenu menu;
    private final List<V> values;

    public MultiSelectBox(String text, Icon icon, List<V> values) {
        super(Objects.requireNonNull(text, "text was null"), icon);
        this.values = Objects.requireNonNull(values, "values was null");
        this.menu = new JPopupMenu();
        for (V value : values) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(value.toString());
            menuItem.addActionListener(e -> {
                this.fireSelectionChangeListeners();
                this.menu.show(this, 0, this.getHeight());
            });
            this.menu.add(menuItem);
            this.menuItems.add(menuItem);
        }
        this.addActionListener(e -> {
            if (!this.menu.isVisible()) {
                Point p = this.getLocationOnScreen();
                this.menu.setInvoker(this);
                this.menu.setLocation((int)p.getX(), (int)p.getY() + this.getHeight());
                this.menu.setVisible(true);
            } else {
                this.menu.setVisible(false);
            }
        });
    }

    public MultiSelectBox(String text, List<V> values) {
        this(text, null, values);
    }

    private void fireSelectionChangeListeners() {
        this.selectionChangeListeners.forEach(l -> l.stateChanged(new ChangeEvent(this)));
    }

    public void addSelectionChangeListener(ChangeListener l) {
        Objects.requireNonNull(l, "l was null");
        this.selectionChangeListeners.add(l);
    }

    public List<V> getSelectedValues() {
        return this.menuItems.stream().filter(JCheckBoxMenuItem::getState).map(menuItem -> this.values.stream().filter(v -> v.toString().equals(menuItem.getText())).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
    }

    public void setSelectedValues(Iterable<V> values) {
        this.menuItems.forEach(menuItem -> {
            boolean enable = StreamSupport.stream(values.spliterator(), false).anyMatch(v -> v.toString().equals(menuItem.getText()));
            menuItem.setState(enable);
        });
        this.fireSelectionChangeListeners();
    }
}

