/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.knime.core.node.NodeLogger;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

final class NodeLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private final transient NodeLogger logger;

    public NodeLoggerAdapter(NodeLogger logger) {
        this.logger = logger;
    }

    public void debug(String msg) {
        this.logger.debug((Object)msg);
    }

    public void debug(String format, Object arg) {
        this.logger.debug((Object)MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void debug(String format, Object ... args) {
        this.logger.debug((Object)MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug((Object)msg, t);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug((Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void error(String msg) {
        this.logger.error((Object)msg);
    }

    public void error(String format, Object arg) {
        this.logger.error((Object)MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void error(String format, Object ... args) {
        this.logger.error((Object)MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void error(String msg, Throwable t) {
        this.logger.error((Object)msg, t);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logger.error((Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void info(String msg) {
        this.logger.info((Object)msg);
    }

    public void info(String format, Object arg) {
        this.logger.info((Object)MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void info(String format, Object ... args) {
        this.logger.info((Object)MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void info(String msg, Throwable t) {
        this.logger.info((Object)msg, t);
    }

    public void info(String msg, Object arg1, Object arg2) {
        this.logger.info((Object)MessageFormatter.format((String)msg, (Object)arg1, (Object)arg2).getMessage());
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor(NodeLogger.LEVEL.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(NodeLogger.LEVEL.ERROR);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor(NodeLogger.LEVEL.INFO);
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(NodeLogger.LEVEL.WARN);
    }

    public void trace(String msg) {
    }

    public void trace(String format, Object arg) {
    }

    public void trace(String format, Object ... args) {
    }

    public void trace(String format, Throwable t) {
    }

    public void trace(String format, Object arg1, Object arg2) {
    }

    public void warn(String msg) {
        this.logger.warn((Object)msg);
    }

    public void warn(String format, Object arg) {
        this.logger.warn((Object)MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void warn(String format, Object ... args) {
        this.logger.warn((Object)MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn((Object)msg, t);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn((Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }
}

