/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.featureselection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.NominalValue;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.classification.featureselection.FeatureRanking;
import ws.palladian.classification.featureselection.InformationGainFeatureRanker;
import ws.palladian.classification.featureselection.RankedFeature;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.helper.ProgressReporter;
import ws.palladian.nodes.KnimeProgressAdapter;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.classification.featureselection.InformationGainCalculatorNodeDialog;

public class InformationGainCalculatorNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(InformationGainCalculatorNodeModel.class);
    static final String CFGKEY_CLASS_COLUMN_NAME = "classColumn";
    private final SettingsModelString settingClassColumnName = InformationGainCalculatorNodeDialog.createSettingsClassColumn();

    protected InformationGainCalculatorNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inputTable = inData[0];
        String classColumnName = this.settingClassColumnName.getStringValue();
        int classIndex = inputTable.getSpec().findColumnIndex(classColumnName);
        String[] columnNames = inputTable.getSpec().getColumnNames();
        ArrayList<Instance> convertedInstances = new ArrayList<Instance>();
        exec.setProgress("Reading input data.");
        for (DataRow inputRow : inputTable) {
            InstanceBuilder instanceBuilder = new InstanceBuilder();
            DataCell classCell = inputRow.getCell(classIndex);
            String classValue = ((NominalValue)classCell).toString();
            int i = 0;
            while (i < inputRow.getNumCells()) {
                if (i != classIndex) {
                    DataCell cell = inputRow.getCell(i);
                    String columnName = columnNames[i];
                    if (cell instanceof DoubleValue) {
                        instanceBuilder.set(columnName, ((DoubleValue)cell).getDoubleValue());
                    } else if (cell instanceof StringValue) {
                        instanceBuilder.set(columnName, ((StringValue)cell).getStringValue());
                    } else {
                        logger.debug((Object)("Skipping cell of type '" + cell.getClass().getName() + "'."));
                    }
                }
                ++i;
            }
            convertedInstances.add(instanceBuilder.create(classValue));
        }
        exec.setProgress("Executing feature ranking.");
        InformationGainFeatureRanker featureRanker = new InformationGainFeatureRanker();
        FeatureRanking featureRanking = featureRanker.rankFeatures(convertedInstances, (ProgressReporter)new KnimeProgressAdapter((ExecutionMonitor)exec));
        exec.setProgress("Creating output table.");
        DataColumnSpec[] allColSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("featureName", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("informationGain", DoubleCell.TYPE).createSpec()};
        DataTableSpec outputSpec = new DataTableSpec(allColSpecs);
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        long idx = 0L;
        for (RankedFeature rankedFeature : featureRanking.getAll()) {
            DataCell[] cells = new DataCell[]{new StringCell(rankedFeature.getName()), new DoubleCell(rankedFeature.getScore())};
            DefaultRow row = new DefaultRow(RowKey.createRowKey((long)idx++), cells);
            container.addRowToTable((DataRow)row);
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[1];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingClassColumnName.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingClassColumnName.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingClassColumnName.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

