/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JComponent;
import org.knime.core.data.filestore.FileStore;
import org.knime.core.data.filestore.FileStorePortObject;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContent;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortObjectZipInputStream;
import org.knime.core.node.port.PortObjectZipOutputStream;
import org.knime.core.node.port.PortType;
import org.knime.core.node.port.PortTypeRegistry;
import ws.palladian.classification.text.DictionaryModel;
import ws.palladian.nodes.classification.text.ITextClassifierPortObject;
import ws.palladian.nodes.classification.text.TextClassifierPortObjectSpec;

public class FileStoreTextClassifierPortObject
extends FileStorePortObject
implements ITextClassifierPortObject {
    public static final PortType TYPE = PortTypeRegistry.getInstance().getPortType(FileStoreTextClassifierPortObject.class);
    private static final String CFG_META_DATA = "modelContent";
    private static final String NUM_UNIQ_TERMS = "numUniqTerms";
    private static final String NUM_CATEGORIES = "numCategories";
    private static final String NUM_ENTRIES = "numEntries";
    private WeakReference<DictionaryModel> modelReference;
    private TextClassifierPortObjectSpec spec;
    private int numUniqTerms;
    private int numCategories;
    private int numEntries;

    public static FileStoreTextClassifierPortObject createPortObject(TextClassifierPortObjectSpec spec, DictionaryModel dictionaryModel, FileStore fileStore) {
        FileStoreTextClassifierPortObject po = new FileStoreTextClassifierPortObject(spec, dictionaryModel, fileStore);
        try {
            FileStoreTextClassifierPortObject.serialize(dictionaryModel, fileStore);
        }
        catch (IOException e) {
            throw new IllegalStateException("Something went wrong during serialization.", e);
        }
        return po;
    }

    private FileStoreTextClassifierPortObject(TextClassifierPortObjectSpec spec, DictionaryModel model, FileStore fileStore) {
        super((List)Lists.newArrayList((Object[])new FileStore[]{fileStore}));
        this.spec = spec;
        this.modelReference = new WeakReference<DictionaryModel>(model);
        this.numUniqTerms = model.getNumUniqTerms();
        this.numCategories = model.getNumCategories();
        this.numEntries = model.getNumEntries();
    }

    public FileStoreTextClassifierPortObject() {
    }

    @Override
    public synchronized DictionaryModel getModel() {
        DictionaryModel dictionaryModel = (DictionaryModel)this.modelReference.get();
        if (dictionaryModel == null) {
            try {
                dictionaryModel = this.deserialize();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException("Something went wrong during deserialization.", e);
            }
            this.modelReference = new WeakReference<DictionaryModel>(dictionaryModel);
        }
        return dictionaryModel;
    }

    private DictionaryModel deserialize() throws IOException, ClassNotFoundException {
        File file = this.getFileStore(0).getFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectInputStream input = new ObjectInputStream(new GZIPInputStream(new FileInputStream(file)));){
            return (DictionaryModel)input.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getSummary() {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
        return String.format("Dictionary: %s terms, %s categories, %s entries", format.format(this.numUniqTerms), format.format(this.numCategories), format.format(this.numEntries));
    }

    public TextClassifierPortObjectSpec getSpec() {
        return this.spec;
    }

    private void save(PortObjectZipOutputStream out, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        ModelContent metaContent = new ModelContent(CFG_META_DATA);
        metaContent.addInt(NUM_UNIQ_TERMS, this.numUniqTerms);
        metaContent.addInt(NUM_CATEGORIES, this.numCategories);
        metaContent.addInt(NUM_ENTRIES, this.numEntries);
        metaContent.saveToXML((OutputStream)out);
    }

    private void load(PortObjectZipInputStream in, PortObjectSpec spec, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        this.spec = (TextClassifierPortObjectSpec)spec;
        this.modelReference = new WeakReference<Object>(null);
        ModelContentRO modelContent = ModelContent.loadFromXML((InputStream)in);
        try {
            this.numUniqTerms = modelContent.getInt(NUM_UNIQ_TERMS);
            this.numCategories = modelContent.getInt(NUM_CATEGORIES);
            this.numEntries = modelContent.getInt(NUM_ENTRIES);
        }
        catch (InvalidSettingsException e) {
            throw new IOException("Unable to restore meta information: " + e.getMessage(), e);
        }
    }

    private static void serialize(DictionaryModel dictionaryModel, FileStore fileStore) throws IOException {
        File file = fileStore.getFile();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
            out.writeObject(dictionaryModel);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public JComponent[] getViews() {
        return new JComponent[0];
    }

    public static final class Serializer
    extends PortObject.PortObjectSerializer<FileStoreTextClassifierPortObject> {
        public void savePortObject(FileStoreTextClassifierPortObject portObject, PortObjectZipOutputStream out, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
            portObject.save(out, exec);
        }

        public FileStoreTextClassifierPortObject loadPortObject(PortObjectZipInputStream in, PortObjectSpec spec, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
            FileStoreTextClassifierPortObject model = new FileStoreTextClassifierPortObject();
            model.load(in, spec, exec);
            return model;
        }
    }
}

