/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.content2;

import java.util.Arrays;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.util.LockedSupplier;
import org.knime.core.data.xml.XMLCell;
import org.knime.core.data.xml.XMLCellFactory;
import org.knime.core.data.xml.XMLValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ws.palladian.extraction.content.PageContentExtractorException;
import ws.palladian.extraction.content.WebPageContentExtractor;
import ws.palladian.helper.html.HtmlHelper;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.content2.ContentExtractor2NodeSettings;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class ContentExtractor2NodeModel
extends SimpleStreamableFunctionNodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(ContentExtractor2NodeModel.class);
    private final ContentExtractor2NodeSettings nodeSettings = new ContentExtractor2NodeSettings();

    ContentExtractor2NodeModel() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec inSpec) throws InvalidSettingsException {
        final int inColIdx = inSpec.findColumnIndex(this.nodeSettings.getSettingInputColumn().getStringValue());
        final DataColumnSpec[] colSpec = new DataColumnSpec[3];
        String columnNamePrefix = this.nodeSettings.getSettingOutputColumnPrefix().getStringValue();
        colSpec[0] = new DataColumnSpecCreator(columnNamePrefix + "Title", StringCell.TYPE).createSpec();
        colSpec[1] = new DataColumnSpecCreator(columnNamePrefix + "Text", StringCell.TYPE).createSpec();
        colSpec[2] = new DataColumnSpecCreator(columnNamePrefix + "Node", XMLCell.TYPE).createSpec();
        AbstractCellFactory cellFactory = new AbstractCellFactory(true, colSpec){

            public DataCell[] getCells(DataRow row) {
                DataCell inputCell = row.getCell(inColIdx);
                Object[] outputCells = new DataCell[colSpec.length];
                Arrays.fill(outputCells, DataType.getMissingCell());
                if (inputCell.isMissing()) {
                    return outputCells;
                }
                XMLValue xmlValue = (XMLValue)inputCell;
                Throwable throwable = null;
                Object var6_7 = null;
                try (LockedSupplier supplier = xmlValue.getDocumentSupplier();){
                    Document document = (Document)supplier.get();
                    WebPageContentExtractor extractor = ContentExtractor2NodeModel.this.nodeSettings.createContentExtractor();
                    try {
                        extractor.setDocument(document);
                    }
                    catch (PageContentExtractorException e) {
                        logger.warn((Object)("Parse error for document in row " + String.valueOf(row.getKey())), (Throwable)e);
                        if (supplier != null) {
                            supplier.close();
                        }
                        return outputCells;
                    }
                    try {
                        outputCells[0] = PalladianKnimeHelper.createStringCell(extractor.getResultTitle());
                        outputCells[1] = PalladianKnimeHelper.createStringCell(extractor.getResultText());
                        String nodeString = HtmlHelper.xmlToString((Node)extractor.getResultNode());
                        outputCells[2] = XMLCellFactory.create((String)nodeString);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Error creating result cells in row " + String.valueOf(row.getKey())), (Throwable)e);
                        if (supplier != null) {
                            supplier.close();
                        }
                        return outputCells;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return outputCells;
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(inSpec);
        rearranger.append((CellFactory)cellFactory);
        if (this.nodeSettings.getSettingRemoveDocumentColumn().getBooleanValue()) {
            rearranger.remove(new int[]{inColIdx});
        }
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.getSettingInputColumn().getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.getSettingInputColumn().getStringValue(), XMLValue.class);
        } else {
            DataColumnSpec inColSpec = PalladianKnimeHelper.guessColumn(inSpec, XMLValue.class);
            this.setWarningMessage("Guessing input column: " + inColSpec.getName());
            this.nodeSettings.getSettingInputColumn().setStringValue(inColSpec.getName());
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }
}

