/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.knime.core.node.NodeLogger;
import ws.palladian.extraction.location.geocoder.Geocoder;
import ws.palladian.extraction.location.geocoder.GeocoderException;
import ws.palladian.helper.collection.LruMap;
import ws.palladian.helper.geo.GeoCoordinate;

final class CachedGeocoder
implements Geocoder {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(CachedGeocoder.class);
    public static final int DEFAULT_CACHE_SIZE = 1000;
    private final Geocoder wrapped;
    private final Map<String, GeoCoordinate> cache;
    private int requestCount = 0;
    private int cacheFail = 0;

    CachedGeocoder(Geocoder wrapped, int cacheSize) {
        this.wrapped = Objects.requireNonNull(wrapped);
        this.cache = Collections.synchronizedMap(LruMap.accessOrder((int)cacheSize));
    }

    public CachedGeocoder(Geocoder wrapped) {
        this(wrapped, 1000);
    }

    public GeoCoordinate geoCode(String addressValue) throws GeocoderException {
        GeoCoordinate geoCoordinate;
        Objects.requireNonNull(addressValue, "addressValue was null");
        try {
            ++this.requestCount;
            geoCoordinate = this.cache.computeIfAbsent(addressValue, value -> {
                try {
                    ++this.cacheFail;
                    return this.wrapped.geoCode(addressValue);
                }
                catch (GeocoderException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (Throwable throwable) {
            LOGGER.debugWithFormat("Cache stats: requests=%s, hits=%s", new Object[]{this.requestCount, this.requestCount - this.cacheFail});
            throw throwable;
        }
        LOGGER.debugWithFormat("Cache stats: requests=%s, hits=%s", new Object[]{this.requestCount, this.requestCount - this.cacheFail});
        return geoCoordinate;
    }
}

