/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.text.NumberFormat;
import java.util.Locale;
import org.knime.core.data.renderer.DefaultDataValueRenderer;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;

public class GeoCoordinateRenderer
extends DefaultDataValueRenderer {
    private static final long serialVersionUID = 2L;
    private final boolean dms;
    private final String description;
    private final NumberFormat numberFormat;

    static {
        NumberFormat.getNumberInstance(Locale.US).setGroupingUsed(false);
    }

    public static final GeoCoordinateRenderer createDms() {
        return new GeoCoordinateRenderer(true, null, "DMS coordinates");
    }

    public static final GeoCoordinateRenderer createDecimalFull() {
        return new GeoCoordinateRenderer(false, null, "Decimal coordinates (full precision)");
    }

    public static final GeoCoordinateRenderer createDecimal() {
        return new GeoCoordinateRenderer(false, NumberFormat.getNumberInstance(Locale.US), "Decimal coordinates");
    }

    private GeoCoordinateRenderer(boolean dms, NumberFormat numberFormat, String description) {
        this.dms = dms;
        this.numberFormat = numberFormat;
        this.description = description;
    }

    protected void setValue(Object value) {
        if (value instanceof GeoCoordinateValue) {
            GeoCoordinateValue coordinate = (GeoCoordinateValue)value;
            if (this.dms) {
                super.setValue((Object)coordinate.toDmsString());
            } else {
                super.setValue((Object)(this.formatDouble(coordinate.getLatitude()) + "," + this.formatDouble(coordinate.getLongitude())));
            }
        } else {
            super.setValue(value);
        }
    }

    private String formatDouble(double doubleValue) {
        return this.numberFormat != null ? this.numberFormat.format(doubleValue) : Double.toString(doubleValue);
    }

    public String getDescription() {
        return this.description;
    }
}

