/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.extraction.location.geocoder.Geocoder;
import ws.palladian.extraction.location.geocoder.GeocoderException;
import ws.palladian.helper.UrlHelper;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.extraction.location.GeocoderNodeDialog;
import ws.palladian.nodes.extraction.location.GeocoderNodeFactory;
import ws.palladian.nodes.extraction.location.GeocoderNodeModel;
import ws.palladian.persistence.json.JsonException;
import ws.palladian.persistence.json.JsonObject;
import ws.palladian.retrieval.HttpException;
import ws.palladian.retrieval.HttpResult;
import ws.palladian.retrieval.HttpRetriever;
import ws.palladian.retrieval.HttpRetrieverFactory;

public class GeoNamesGeocoderNodeFactory
extends GeocoderNodeFactory {
    private static final String CFGKEY_USERNAME = "username";

    static SettingsModelString createSettingsUsername() {
        return new SettingsModelString(CFGKEY_USERNAME, null);
    }

    @Override
    public NodeDialogPane createNodeDialogPane() {
        DefaultNodeSettingsPane dialog = new DefaultNodeSettingsPane();
        dialog.addDialogComponent((DialogComponent)new DialogComponentString(GeoNamesGeocoderNodeFactory.createSettingsUsername(), "GeoNames Username", true, 32));
        dialog.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(GeocoderNodeDialog.createSettingsInputColumn(), "Input", 0, new Class[]{StringValue.class}));
        return dialog;
    }

    public GeocoderNodeModel createNodeModel() {
        return new GeocoderNodeModel(){
            private final SettingsModelString settingUsername = GeoNamesGeocoderNodeFactory.createSettingsUsername();

            @Override
            protected Geocoder createGeocoder() {
                return new Geocoder(){

                    public GeoCoordinate geoCode(String text) throws GeocoderException {
                        JsonObject jsonAddress;
                        block5: {
                            HttpRetriever retriever = HttpRetrieverFactory.getHttpRetriever();
                            String username = settingUsername.getStringValue();
                            if (username == null || username.isEmpty()) {
                                throw new IllegalArgumentException("Username is missing.");
                            }
                            String url = String.format("http://api.geonames.org/geoCodeAddressJSON?q=%s&username=%s", UrlHelper.encodeParameter((String)text), username);
                            HttpResult result = retriever.httpGet(url);
                            JsonObject jsonObject = new JsonObject(result.getStringContent());
                            jsonAddress = jsonObject.getJsonObject("address");
                            if (jsonAddress != null) break block5;
                            return null;
                        }
                        try {
                            double lat = jsonAddress.getDouble("lat");
                            double lng = jsonAddress.getDouble("lng");
                            return GeoCoordinate.from((double)lat, (double)lng);
                        }
                        catch (HttpException e) {
                            throw new GeocoderException((Throwable)e);
                        }
                        catch (JsonException e) {
                            throw new GeocoderException((Throwable)e);
                        }
                    }
                };
            }

            @Override
            protected void saveSettingsTo(NodeSettingsWO settings) {
                this.settingUsername.saveSettingsTo(settings);
                super.saveSettingsTo(settings);
            }

            @Override
            protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
                this.settingUsername.loadSettingsFrom(settings);
                super.loadValidatedSettingsFrom(settings);
            }

            @Override
            protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
                this.settingUsername.validateSettings(settings);
                super.validateSettings(settings);
            }
        };
    }
}

