/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.property.ColorAttr;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettings;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.extraction.location.InfoWaypoint;
import ws.palladian.nodes.extraction.location.MapViewerNodeDialog;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

@Deprecated
public class MapViewerNodeModel
extends NodeModel {
    static final int LOCATION_TABLE_IDX = 0;
    private static final String WAYPOINTS_FILE_NAME = "waypoints.xml";
    static final String CFGKEY_INPUT_COORDINATE_NAME = "settingCoordinateInputColumn";
    static final String CFGKEY_INPUT_LABEL = "settingLabelInputColumn";
    private final SettingsModelString settingInputColumn = MapViewerNodeDialog.createSettingsCoordinatesColumn();
    private final SettingsModelString settingLabelColumn = MapViewerNodeDialog.createSettingsLabelColumn();
    private final Set<InfoWaypoint> waypoints = new LinkedHashSet<InfoWaypoint>();

    protected MapViewerNodeModel() {
        super(1, 0);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inputTable = inData[0];
        DataTableSpec inputSpec = inputTable.getDataTableSpec();
        int inputColIndex = inputSpec.findColumnIndex(this.settingInputColumn.getStringValue());
        if (inputColIndex < 0) {
            throw new IllegalArgumentException("Invalid settings for input column (" + inputColIndex + "). Please (re)configure the node correctly.");
        }
        int labelColIndex = inputSpec.findColumnIndex(this.settingLabelColumn.getStringValue());
        long index = 0L;
        long rowCount = inputTable.size();
        HashSet<Integer> coordinateDuplicateCheck = new HashSet<Integer>();
        for (DataRow row : inputTable) {
            GeoCoordinateValue geoCoordinate;
            DataCell geoCell = row.getCell(inputColIndex);
            if (geoCell.isMissing() || !coordinateDuplicateCheck.add((geoCoordinate = (GeoCoordinateValue)geoCell).hashCode())) continue;
            ColorAttr rowColor = inputSpec.getRowColor(row);
            Color color = rowColor.getColor();
            double size = inputSpec.getRowSizeFactor(row);
            String label = "";
            if (labelColIndex != -1 && !row.getCell(labelColIndex).isMissing()) {
                label = ((StringValue)row.getCell(labelColIndex)).getStringValue();
            }
            this.waypoints.add(new InfoWaypoint(geoCoordinate, color, label, size, row.getKey()));
            exec.checkCanceled();
            exec.setProgress((double)index / (double)rowCount, "Processing row " + index);
            ++index;
        }
        return new BufferedDataTable[0];
    }

    protected void reset() {
        this.waypoints.clear();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingInputColumn.getStringValue(), GeoCoordinateValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, GeoCoordinateValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingInputColumn.setStringValue(columnName);
        }
        return new DataTableSpec[0];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
        this.settingLabelColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
        this.settingLabelColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
        this.settingLabelColumn.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(internDir, WAYPOINTS_FILE_NAME)));){
                NodeSettingsRO settings = NodeSettings.loadFromXML((InputStream)in);
                int numLocations = settings.getInt("numLocations");
                int i = 0;
                while (i < numLocations) {
                    NodeSettingsRO locSetting = settings.getNodeSettings("l_" + i);
                    double lat = locSetting.getDouble("lat");
                    double lng = locSetting.getDouble("lng");
                    Color color = new Color(locSetting.getInt("color"));
                    String label = locSetting.getString("label");
                    RowKey rowKey = locSetting.getRowKey("rowKey");
                    double size = locSetting.containsKey("size") ? locSetting.getDouble("size") : 1.0;
                    this.waypoints.add(new InfoWaypoint(lat, lng, color, label, size, rowKey));
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.setWarningMessage("Error while restoring the view state: " + e.toString() + ". Reset and re-run the node to get the view. Sorry.");
        }
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(internDir, WAYPOINTS_FILE_NAME)));){
            NodeSettings settings = new NodeSettings("LocationViewer");
            settings.addInt("numLocations", this.waypoints.size());
            int i = 0;
            for (InfoWaypoint wp : this.waypoints) {
                NodeSettingsWO locSetting = settings.addNodeSettings("l_" + i++);
                locSetting.addDouble("lat", wp.getPosition().getLatitude());
                locSetting.addDouble("lng", wp.getPosition().getLongitude());
                locSetting.addInt("color", wp.getColor().getRGB());
                locSetting.addString("label", wp.getLabel());
                locSetting.addRowKey("rowKey", wp.getRowKey());
                locSetting.addDouble("size", wp.getSize());
            }
            settings.saveToXML((OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Set<InfoWaypoint> getWaypoints() {
        return this.waypoints;
    }
}

