/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.jxmapviewer.viewer.Waypoint;
import org.jxmapviewer.viewer.WaypointPainter;
import org.jxmapviewer.viewer.WaypointRenderer;
import org.knime.core.data.RowKey;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeView;
import org.knime.core.node.property.hilite.HiLiteListener;
import org.knime.core.node.property.hilite.KeyEvent;
import ws.palladian.nodes.extraction.location.InfoWaypoint;
import ws.palladian.nodes.extraction.location.MapViewerNodeModel;
import ws.palladian.nodes.extraction.location.tiles.AppleTileFactoryInfo;
import ws.palladian.nodes.extraction.location.tiles.StamenTileFactoryInfo;
import ws.palladian.nodes.extraction.location.tiles.VirtualEarthTileFactoryInfo;
import ws.palladian.nodes.extraction.location.tiles.WikimediaMaps;
import ws.palladian.nodes.extraction.location.waypointrenderer.CircleWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.DropWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.InfoWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.LabelWaypointRenderer;

@Deprecated
public class MapViewerNodeView
extends NodeView<MapViewerNodeModel>
implements HiLiteListener {
    private static final NodeLogger logger = NodeLogger.getLogger(MapViewerNodeView.class);
    private static final InfoWaypointRenderer defaultRenderer = new DropWaypointRenderer();
    private static final TileFactoryInfo defaultTileFactory = new OSMTileFactoryInfo();
    private static final Set<InfoWaypointRenderer> renderers = new LinkedHashSet<InfoWaypointRenderer>();
    private static final List<TileFactoryInfo> tileFactories = new ArrayList<TileFactoryInfo>();
    private final JXMapKit mapKit;
    private InfoWaypointRenderer renderer = defaultRenderer;
    private final TileFactoryInfo tileFactory = defaultTileFactory;
    private final WaypointPainter<InfoWaypoint> painter;

    static {
        renderers.add(defaultRenderer);
        renderers.add(new LabelWaypointRenderer());
        renderers.add(new CircleWaypointRenderer());
        tileFactories.add(defaultTileFactory);
        tileFactories.add(AppleTileFactoryInfo.APPLE);
        tileFactories.add((TileFactoryInfo)new VirtualEarthTileFactoryInfo(org.jxmapviewer.VirtualEarthTileFactoryInfo.MAP));
        tileFactories.add((TileFactoryInfo)new VirtualEarthTileFactoryInfo(org.jxmapviewer.VirtualEarthTileFactoryInfo.SATELLITE));
        tileFactories.add((TileFactoryInfo)new VirtualEarthTileFactoryInfo(org.jxmapviewer.VirtualEarthTileFactoryInfo.HYBRID));
        tileFactories.add(new StamenTileFactoryInfo(StamenTileFactoryInfo.Type.TONER));
        tileFactories.add(new StamenTileFactoryInfo(StamenTileFactoryInfo.Type.TERRAIN));
        tileFactories.add(new StamenTileFactoryInfo(StamenTileFactoryInfo.Type.WATERCOLOR));
        tileFactories.add(WikimediaMaps.INSTANCE);
        Collections.sort(tileFactories, Comparator.comparing(TileFactoryInfo::getName));
    }

    protected MapViewerNodeView(MapViewerNodeModel nodeModel) {
        super((NodeModel)nodeModel);
        this.mapKit = new JXMapKit();
        this.mapKit.setPreferredSize(new Dimension(500, 500));
        this.mapKit.setMiniMapVisible(false);
        this.mapKit.setTileFactory((TileFactory)new DefaultTileFactory(this.tileFactory));
        this.setComponent((Component)this.mapKit);
        JMenu viewMenu = new JMenu("View");
        JMenuItem centerItem = new JMenuItem("Show all");
        viewMenu.add(centerItem);
        centerItem.addActionListener(e -> this.showAll());
        this.getJMenuBar().add(viewMenu);
        JMenu rendererMenu = this.createRendererMenu();
        this.getJMenuBar().add(rendererMenu);
        JMenu tileMenu = this.createTileProviderMenu();
        this.getJMenuBar().add(tileMenu);
        JMenu hiliteMenu = this.createHiliteMenu();
        this.getJMenuBar().add(hiliteMenu);
        JXMapViewer mainMap = this.mapKit.getMainMap();
        this.painter = new WaypointPainter();
        this.painter.setRenderer((WaypointRenderer)this.renderer);
        mainMap.setOverlayPainter(this.painter);
        mainMap.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InfoWaypoint waypoint = MapViewerNodeView.this.getWaypoint(e.getPoint());
                if (waypoint == null || !e.isShiftDown()) {
                    MapViewerNodeView.this.clearSelections();
                }
                if (waypoint != null) {
                    logger.debug((Object)("Clicked " + String.valueOf(waypoint)));
                    waypoint.setSelected(true);
                    MapViewerNodeView.this.mapKit.repaint();
                }
            }
        });
    }

    private InfoWaypoint getWaypoint(Point point) {
        JXMapViewer mainMap = this.mapKit.getMainMap();
        Graphics2D graphics = (Graphics2D)mainMap.getGraphics();
        Rectangle viewport = mainMap.getViewportBounds();
        int zoom = mainMap.getZoom();
        TileFactory tileFactory = mainMap.getTileFactory();
        int tileSize = tileFactory.getTileSize(zoom);
        int width = tileFactory.getMapSize((int)zoom).width * tileSize;
        int vpx = (int)viewport.getX() % width;
        if (vpx < 0) {
            vpx += width;
        }
        for (InfoWaypoint waypoint : this.painter.getWaypoints()) {
            Point2D p2d = tileFactory.geoToPixel(waypoint.getPosition(), zoom);
            Shape renderedShape = this.renderer.getShape(graphics, waypoint);
            Shape shape1 = MapViewerNodeView.move(renderedShape, (int)p2d.getX() - vpx, (int)p2d.getY() - viewport.y);
            Shape shape2 = MapViewerNodeView.move(renderedShape, (int)p2d.getX() - vpx + width, (int)p2d.getY() - viewport.y);
            if (!shape1.contains(point) && !shape2.contains(point)) continue;
            return waypoint;
        }
        return null;
    }

    public static final Shape move(Shape shape, double x, double y) {
        AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
        return transform.createTransformedShape(shape);
    }

    private JMenu createHiliteMenu() {
        JMenu hiliteMenu = new JMenu("HiLite");
        JMenuItem hiliteItem = new JMenuItem("HiLite selected");
        hiliteMenu.add(hiliteItem);
        hiliteItem.addActionListener(arge -> {
            HashSet<RowKey> ids = new HashSet<RowKey>();
            Set<InfoWaypoint> selected = this.getSelected();
            for (InfoWaypoint infoWaypoint : selected) {
                ids.add(infoWaypoint.getRowKey());
                infoWaypoint.setHilited(true);
                infoWaypoint.setSelected(false);
            }
            ((MapViewerNodeModel)this.getNodeModel()).getInHiLiteHandler(0).fireHiLiteEvent(ids);
            this.mapKit.repaint();
        });
        JMenuItem unhiliteItem = new JMenuItem("UnHiLite selected");
        unhiliteItem.addActionListener(e -> {
            HashSet<RowKey> ids = new HashSet<RowKey>();
            Set<InfoWaypoint> selected = this.getSelected();
            for (InfoWaypoint infoWaypoint : selected) {
                ids.add(infoWaypoint.getRowKey());
                infoWaypoint.setHilited(false);
                infoWaypoint.setSelected(false);
            }
            ((MapViewerNodeModel)this.getNodeModel()).getInHiLiteHandler(0).fireUnHiLiteEvent(ids);
            this.mapKit.repaint();
        });
        hiliteMenu.add(unhiliteItem);
        JMenuItem clearItem = new JMenuItem("Clear HiLite");
        hiliteMenu.add(clearItem);
        clearItem.addActionListener(e -> this.clearHilites());
        return hiliteMenu;
    }

    private Set<InfoWaypoint> getSelected() {
        HashSet<InfoWaypoint> selected = new HashSet<InfoWaypoint>();
        for (Waypoint waypoint : this.painter.getWaypoints()) {
            InfoWaypoint infoWaypoint = (InfoWaypoint)waypoint;
            if (!infoWaypoint.isSelected()) continue;
            selected.add(infoWaypoint);
        }
        return selected;
    }

    private void clearSelections() {
        for (Waypoint waypoint : this.painter.getWaypoints()) {
            InfoWaypoint infoWaypoint = (InfoWaypoint)waypoint;
            infoWaypoint.setSelected(false);
        }
        this.mapKit.repaint();
    }

    private void clearHilites() {
        for (Waypoint waypoint : this.painter.getWaypoints()) {
            InfoWaypoint infoWaypoint = (InfoWaypoint)waypoint;
            infoWaypoint.setHilited(false);
        }
        ((MapViewerNodeModel)this.getNodeModel()).getInHiLiteHandler(0).fireClearHiLiteEvent();
        this.mapKit.repaint();
    }

    private JMenu createRendererMenu() {
        JMenu rendererMenu = new JMenu("Location Renderer");
        ButtonGroup rendererGroup = new ButtonGroup();
        for (InfoWaypointRenderer renderer : renderers) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(renderer.getName());
            rendererGroup.add(menuItem);
            menuItem.addActionListener(e -> this.setRenderer(renderer));
            rendererMenu.add(menuItem);
            if (renderer != defaultRenderer) continue;
            rendererGroup.setSelected(menuItem.getModel(), true);
        }
        return rendererMenu;
    }

    private JMenu createTileProviderMenu() {
        JMenu providerMenu = new JMenu("Tile Provider");
        ButtonGroup providerGroup = new ButtonGroup();
        for (TileFactoryInfo tileFactoryInfo : tileFactories) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(tileFactoryInfo.getName());
            providerGroup.add(menuItem);
            menuItem.addActionListener(e -> {
                int maxZoom = tileFactoryInfo.getMaximumZoomLevel();
                if (this.mapKit.getMainMap().getZoom() > maxZoom) {
                    logger.debug((Object)("Zoom was set to " + this.mapKit.getMainMap().getZoom() + ", reducing zoom to " + maxZoom));
                    this.mapKit.setZoom(maxZoom);
                }
                this.mapKit.setTileFactory((TileFactory)new DefaultTileFactory(tileFactoryInfo));
                this.showAll();
            });
            providerMenu.add(menuItem);
            if (tileFactoryInfo != defaultTileFactory) continue;
            providerGroup.setSelected(menuItem.getModel(), true);
        }
        return providerMenu;
    }

    protected void modelChanged() {
        Set<InfoWaypoint> waypoints = ((MapViewerNodeModel)this.getNodeModel()).getWaypoints();
        this.painter.setWaypoints(Collections.unmodifiableSet(waypoints));
        SwingUtilities.invokeLater(() -> this.showAll());
    }

    private void showAll() {
        Set points = this.painter.getWaypoints().stream().map(Waypoint::getPosition).collect(Collectors.toSet());
        if (points.isEmpty()) {
            this.mapKit.getMainMap().setZoom(this.tileFactory.getMaximumZoomLevel());
        } else if (points.size() == 1) {
            int zoomLevel = (int)Math.round((double)(this.tileFactory.getMinimumZoomLevel() + this.tileFactory.getMaximumZoomLevel()) / 2.0);
            this.mapKit.getMainMap().setZoom(zoomLevel);
            this.mapKit.getMainMap().setCenterPosition((GeoPosition)points.iterator().next());
        } else {
            this.mapKit.getMainMap().zoomToBestFit(points, 0.9);
        }
    }

    protected void onClose() {
        ((MapViewerNodeModel)this.getNodeModel()).getInHiLiteHandler(0).removeHiLiteListener((HiLiteListener)this);
    }

    protected void onOpen() {
        ((MapViewerNodeModel)this.getNodeModel()).getInHiLiteHandler(0).addHiLiteListener((HiLiteListener)this);
    }

    public void hiLite(KeyEvent event) {
        if (!event.isEmpty()) {
            this.updateHilite();
        }
    }

    public void unHiLite(KeyEvent event) {
        if (!event.isEmpty()) {
            this.updateHilite();
        }
    }

    public void unHiLiteAll(KeyEvent event) {
        this.clearHilites();
    }

    private void updateHilite() {
        Set hiLitKeys = ((MapViewerNodeModel)this.getNodeModel()).getInHiLiteHandler(0).getHiLitKeys();
        for (Waypoint waypoint : this.painter.getWaypoints()) {
            InfoWaypoint infoWaypoint = (InfoWaypoint)waypoint;
            boolean hiLit = hiLitKeys.contains(infoWaypoint.getRowKey());
            infoWaypoint.setHilited(hiLit);
        }
        this.mapKit.repaint();
    }

    private void setRenderer(InfoWaypointRenderer renderer) {
        this.painter.setRenderer((WaypointRenderer)renderer);
        this.renderer = renderer;
        this.mapKit.repaint();
    }
}

