/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;

public class SelectionAdapter
extends MouseAdapter
implements Painter<JXMapViewer> {
    private Rectangle rect;
    private Rectangle start;
    private Rectangle end;
    private final Color borderColor = new Color(0, 0, 200);
    private final Color regionColor = new Color(0, 0, 200, 75);

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            this.rect = null;
            this.start = null;
        } else {
            this.start = new Rectangle(e.getPoint());
            ((JXMapViewer)e.getSource()).setPanEnabled(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.start != null) {
            this.end = new Rectangle(e.getPoint());
            this.rect = this.start.union(this.end);
        }
        ((JXMapViewer)e.getSource()).repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.start == null) {
            return;
        }
        this.end = new Rectangle(e.getPoint());
        this.rect = this.start.union(this.end);
        ((JXMapViewer)e.getSource()).setPanEnabled(true);
        ((JXMapViewer)e.getSource()).repaint();
    }

    public void paint(Graphics2D g, JXMapViewer c, int width, int height) {
        if (this.rect != null) {
            g.setColor(this.regionColor);
            g.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            g.setColor(this.borderColor);
            g.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
    }
}

