/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.tiles;

import org.apache.commons.lang3.StringUtils;
import org.jxmapviewer.viewer.TileFactoryInfo;

public final class StamenTileFactoryInfo
extends TileFactoryInfo {
    private static final int TILE_SIZE = 256;
    private final Type type;

    public StamenTileFactoryInfo(Type type) {
        super("Stamen", type.minZoom, type.maxZoom, type.maxZoom, 256, true, true, type.getUrl(), null, null, null);
        this.type = type;
    }

    public String getTileUrl(int x, int y, int zoom) {
        String url = this.getBaseURL();
        int z = this.getMaximumZoomLevel() - zoom;
        url = url.replace("{t}", this.getRandomSubdomain(x, y, zoom));
        url = url.replace("{Z}", String.valueOf(z));
        url = url.replace("{X}", String.valueOf(x));
        url = url.replace("{Y}", String.valueOf(y));
        return url;
    }

    private String getRandomSubdomain(int x, int y, int zoom) {
        return this.type.subdomains[(x + y + zoom) % this.type.subdomains.length];
    }

    public String getName() {
        return super.getName() + " " + StringUtils.capitalize((String)this.type.layer);
    }

    public static enum Type {
        TONER("toner", "png", 0, 20),
        TERRAIN("terrain", "png", 0, 18),
        WATERCOLOR("watercolor", "png", 1, 18);

        final String layer;
        final String type;
        final int minZoom;
        final int maxZoom;
        final String[] subdomains = new String[]{"a", "b", "c", "d"};

        private Type(String layer, String type, int minZoom, int maxZoom) {
            this.layer = layer;
            this.type = type;
            this.minZoom = minZoom;
            this.maxZoom = maxZoom;
        }

        private String getUrl() {
            return String.format("http://{t}.tile.stamen.com/%s/{Z}/{X}/{Y}.%s", this.layer, this.type);
        }
    }
}

