/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location2.extractor;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.streamable.InputPortRole;
import org.knime.core.node.streamable.OutputPortRole;
import org.knime.core.node.streamable.PartitionInfo;
import org.knime.core.node.streamable.PortInput;
import org.knime.core.node.streamable.PortObjectInput;
import org.knime.core.node.streamable.PortOutput;
import org.knime.core.node.streamable.RowInput;
import org.knime.core.node.streamable.RowOutput;
import org.knime.core.node.streamable.StreamableOperator;
import ws.palladian.classification.dt.QuickDtModel;
import ws.palladian.extraction.location.Location;
import ws.palladian.extraction.location.LocationAnnotation;
import ws.palladian.extraction.location.LocationExtractor;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.extraction.location.PalladianLocationExtractor;
import ws.palladian.extraction.location.disambiguation.FeatureBasedDisambiguation;
import ws.palladian.extraction.location.disambiguation.HeuristicDisambiguation;
import ws.palladian.extraction.location.disambiguation.LocationDisambiguation;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location2.extractor.LocationExtractor2NodeSettings;
import ws.palladian.nodes.extraction.location2.port.LocationSourcePortObject;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class LocationExtractor2NodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(LocationExtractor2NodeModel.class);
    static final int INPORT_CONNECTOR = 0;
    static final int INPORT_TABLE = 1;
    private final LocationExtractor2NodeSettings nodeSettings = new LocationExtractor2NodeSettings();

    protected LocationExtractor2NodeModel() {
        super(new PortType[]{LocationSourcePortObject.TYPE, BufferedDataTable.TYPE}, new PortType[]{BufferedDataTable.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inputTable = (BufferedDataTable)inObjects[1];
        LocationSourcePortObject locationSourcePO = (LocationSourcePortObject)inObjects[0];
        DataTableSpec inputSpec = inputTable.getDataTableSpec();
        MappingStrategy mappingStrategy = this.nodeSettings.getMappingStrategy();
        DataTableSpec outputSpec = mappingStrategy.createSpec(inputSpec, this.nodeSettings);
        LocationSource locationSource = locationSourcePO.getSpec().createSource();
        try {
            LocationDisambiguation disambiguation = this.nodeSettings.getDisambiguation();
            PalladianLocationExtractor locationExtractor = new PalladianLocationExtractor(locationSource, disambiguation);
            BufferedDataContainer container = exec.createDataContainer(outputSpec);
            long inRowIndex = 0L;
            long inRowCount = inputTable.size();
            int textColumnIndex = inputSpec.findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
            if (textColumnIndex < 0) {
                throw new IllegalArgumentException("Invalid settings for input column (" + textColumnIndex + "). Please (re)configure the node correctly.");
            }
            for (DataRow row : inputTable) {
                ++inRowIndex;
                List<DataRow> rows = mappingStrategy.process(row, (LocationExtractor)locationExtractor, textColumnIndex);
                rows.forEach(arg_0 -> ((BufferedDataContainer)container).addRowToTable(arg_0));
                exec.checkCanceled();
                exec.setProgress((double)inRowIndex / (double)inRowCount, "Processing row " + String.valueOf(row.getKey()));
            }
            container.close();
            BufferedDataTable out = container.getTable();
            BufferedDataTable[] bufferedDataTableArray = new BufferedDataTable[]{out};
            return bufferedDataTableArray;
        }
        finally {
            if (locationSource instanceof Closeable) {
                ((Closeable)locationSource).close();
            }
        }
    }

    protected void reset() {
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = (DataTableSpec)inSpecs[1];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.inputColumn.getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.inputColumn.getStringValue(), StringValue.class);
        } else {
            DataColumnSpec inColSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            this.setWarningMessage("Guessing input column: " + inColSpec.getName());
            this.nodeSettings.inputColumn.setStringValue(inColSpec.getName());
        }
        MappingStrategy mappingStrategy = this.nodeSettings.getMappingStrategy();
        DataTableSpec outSpec = mappingStrategy.createSpec(inSpec, this.nodeSettings);
        return new DataTableSpec[]{outSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    public InputPortRole[] getInputPortRoles() {
        return new InputPortRole[]{InputPortRole.NONDISTRIBUTED_NONSTREAMABLE, InputPortRole.NONDISTRIBUTED_STREAMABLE};
    }

    public OutputPortRole[] getOutputPortRoles() {
        return new OutputPortRole[]{OutputPortRole.NONDISTRIBUTED};
    }

    public StreamableOperator createStreamableOperator(PartitionInfo partitionInfo, PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        PalladianPluginActivator.checkLicense();
        final int textColumnIndex = ((DataTableSpec)inSpecs[1]).findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        if (textColumnIndex < 0) {
            throw new IllegalArgumentException("Invalid settings for input column (" + textColumnIndex + "). Please (re)configure the node correctly.");
        }
        final MappingStrategy mappingStrategy = this.nodeSettings.getMappingStrategy();
        return new StreamableOperator(){

            public void runFinal(PortInput[] inputs, PortOutput[] outputs, ExecutionContext exec) throws Exception {
                PortObjectInput portObjectInput = (PortObjectInput)inputs[0];
                LocationSourcePortObject locationSourcePO = (LocationSourcePortObject)portObjectInput.getPortObject();
                RowInput rowInput = (RowInput)inputs[1];
                RowOutput rowOutput = (RowOutput)outputs[0];
                LocationSource locationSource = locationSourcePO.getSpec().createSource();
                try {
                    DataRow row;
                    LocationDisambiguation disambiguation = LocationExtractor2NodeModel.this.nodeSettings.getDisambiguation();
                    PalladianLocationExtractor locationExtractor = new PalladianLocationExtractor(locationSource, disambiguation);
                    while ((row = rowInput.poll()) != null) {
                        exec.checkCanceled();
                        exec.setProgress("Processing row " + String.valueOf(row.getKey()));
                        List<DataRow> extractedRows = mappingStrategy.process(row, (LocationExtractor)locationExtractor, textColumnIndex);
                        for (DataRow extractedRow : extractedRows) {
                            rowOutput.push(extractedRow);
                        }
                    }
                    rowInput.close();
                    rowOutput.close();
                }
                finally {
                    if (locationSource instanceof Closeable) {
                        ((Closeable)locationSource).close();
                    }
                }
            }
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum DisambiguationMethod {
        ML_ALL("ML (730-docs-10T)", true){
            static final String MODEL = "platform:/plugin/ws.palladian.nodes/resources/ld-all-training-10t.ser.gz";

            @Override
            LocationDisambiguation createDisambiguation(LocationExtractor2NodeSettings settings) throws Exception {
                return new FeatureBasedDisambiguation(DisambiguationMethod.loadModel(MODEL), settings.disambiguationTrust.getDoubleValue());
            }
        }
        ,
        ML_TUD_LOC_2013("ML (TUD-Loc-2013-10T)", true){
            static final String MODEL = "platform:/plugin/ws.palladian.nodes/resources/ld-tud-loc-2013-10t.ser.gz";

            @Override
            LocationDisambiguation createDisambiguation(LocationExtractor2NodeSettings settings) throws Exception {
                return new FeatureBasedDisambiguation(DisambiguationMethod.loadModel(MODEL), settings.disambiguationTrust.getDoubleValue());
            }
        }
        ,
        HEURISTIC("Heuristic", false){

            @Override
            LocationDisambiguation createDisambiguation(LocationExtractor2NodeSettings settings) {
                return new HeuristicDisambiguation();
            }
        };

        final String label;
        final boolean supportsTrust;

        private DisambiguationMethod(String label, boolean supportsTrust) {
            this.label = label;
            this.supportsTrust = supportsTrust;
        }

        abstract LocationDisambiguation createDisambiguation(LocationExtractor2NodeSettings var1) throws Exception;

        final boolean supportsTrust() {
            return this.supportsTrust;
        }

        static String[] getLabels() {
            return (String[])Arrays.stream(DisambiguationMethod.values()).map(m -> m.label).toArray(String[]::new);
        }

        static DisambiguationMethod getByLabel(String label) {
            return Arrays.stream(DisambiguationMethod.values()).filter(m -> m.label.equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown disambiguation method: " + label));
        }

        private static QuickDtModel loadModel(String url) throws Exception {
            Throwable throwable = null;
            Object var2_3 = null;
            try (GZIPInputStream inputStream = new GZIPInputStream(new URL(url).openConnection().getInputStream());){
                return (QuickDtModel)new ObjectInputStream(inputStream).readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum MappingStrategy {
        ROWS("Rows"){

            @Override
            List<DataRow> map(DataRow inRow, List<LocationAnnotation> annotations) {
                long outRowIndex = 0L;
                ArrayList<DataRow> rows = new ArrayList<DataRow>();
                for (LocationAnnotation annotation : annotations) {
                    LOGGER.debugWithFormat("Extracted %s", new Object[]{annotation});
                    Location location = annotation.getLocation();
                    ArrayList<Object> cells = new ArrayList<Object>();
                    cells.add(new StringCell(inRow.getKey().getString()));
                    cells.add(new StringCell(annotation.getValue()));
                    cells.add(new IntCell(annotation.getStartPosition()));
                    cells.add(new IntCell(annotation.getEndPosition()));
                    cells.add(new IntCell(location.getId()));
                    cells.add(new StringCell(location.getPrimaryName()));
                    cells.add(CollectionCellFactory.createListCell((Collection)location.getAlternativeNames().stream().map(an -> new StringCell(an.getName())).collect(Collectors.toCollection(LinkedHashSet::new))));
                    cells.add(new StringCell(location.getType().toString()));
                    cells.add(location.getCoords().map(GeoCoordinateCell::new).orElse(DataType.getMissingCell()));
                    cells.add(Optional.ofNullable(location.getPopulation()).map(LongCell::new).orElse(DataType.getMissingCell()));
                    cells.add(CollectionCellFactory.createListCell((Collection)location.getAncestorIds().stream().map(IntCell::new).collect(Collectors.toList())));
                    cells.add(annotation.getTrust() != -1.0 ? new DoubleCell(annotation.getTrust()) : DataType.getMissingCell());
                    RowKey rowKey = new RowKey(inRow.getKey().getString() + "_" + outRowIndex++);
                    rows.add((DataRow)new AppendedColumnRow(rowKey, inRow, cells.toArray(new DataCell[0])));
                }
                return rows;
            }

            @Override
            DataTableSpec createSpec(DataTableSpec inSpec, LocationExtractor2NodeSettings settings) {
                String prefixString = Optional.ofNullable(settings.outputColumnPrefix.getStringValue()).orElse("");
                ArrayList<DataColumnSpec> spec = new ArrayList<DataColumnSpec>();
                spec.add(new DataColumnSpecCreator(prefixString + "RowID", StringCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Annotation Value", StringCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Annotation Start", IntCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Annotation End", IntCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location ID", IntCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Name", StringCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Alternative Names", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Type", StringCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Coordinates", GeoCoordinateCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Population", LongCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Ancestor IDs", ListCell.getCollectionType((DataType)IntCell.TYPE)).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Trust", DoubleCell.TYPE).createSpec());
                return new DataTableSpec(inSpec, new DataTableSpec((DataColumnSpec[])spec.toArray(DataColumnSpec[]::new)));
            }
        }
        ,
        ROWS_OR_MISSING("Rows or Missing"){

            @Override
            List<DataRow> map(DataRow inRow, List<LocationAnnotation> annotations) throws Exception {
                if (annotations.size() > 0) {
                    return ROWS.map(inRow, annotations);
                }
                ArrayList<Object> cells = new ArrayList<Object>();
                cells.add(new StringCell(inRow.getKey().getString()));
                cells.addAll(Collections.nCopies(11, DataType.getMissingCell()));
                return Collections.singletonList(new AppendedColumnRow(inRow.getKey(), inRow, (DataCell[])cells.toArray(DataCell[]::new)));
            }

            @Override
            DataTableSpec createSpec(DataTableSpec inSpec, LocationExtractor2NodeSettings settings) {
                return ROWS.createSpec(inSpec, settings);
            }
        }
        ,
        JSON("JSON"){

            @Override
            List<DataRow> map(DataRow inRow, List<LocationAnnotation> annotations) throws Exception {
                ObjectMapper mapper = new ObjectMapper();
                mapper.registerModule((Module)new Jdk8Module());
                mapper.setConfig((SerializationConfig)mapper.getSerializationConfig().with(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY}));
                String json = mapper.writeValueAsString(annotations);
                DataCell resultCell = JSONCellFactory.create((String)json, (boolean)false);
                return Collections.singletonList(new AppendedColumnRow(inRow.getKey(), inRow, new DataCell[]{resultCell}));
            }

            @Override
            DataTableSpec createSpec(DataTableSpec inSpec, LocationExtractor2NodeSettings settings) {
                String prefixString = Optional.ofNullable(settings.outputColumnPrefix.getStringValue()).orElse("");
                return new DataTableSpec(inSpec, new DataTableSpec(new DataColumnSpec[]{new DataColumnSpecCreator(prefixString + "JSON", JSONCell.TYPE).createSpec()}));
            }
        };

        final String label;

        private MappingStrategy(String label) {
            this.label = label;
        }

        abstract List<DataRow> map(DataRow var1, List<LocationAnnotation> var2) throws Exception;

        final List<DataRow> process(DataRow row, LocationExtractor locationExtractor, int textColumnIndex) throws Exception {
            List annotations;
            LOGGER.debugWithFormat("Processing row %s", new Object[]{row.getKey()});
            if (row.getCell(textColumnIndex).isMissing()) {
                annotations = Collections.emptyList();
            } else {
                String text = ((StringValue)row.getCell(textColumnIndex)).getStringValue();
                annotations = locationExtractor.getAnnotations(text);
            }
            return this.map(row, annotations);
        }

        abstract DataTableSpec createSpec(DataTableSpec var1, LocationExtractor2NodeSettings var2);

        static String[] getLabels() {
            return (String[])Arrays.stream(MappingStrategy.values()).map(m -> m.label).toArray(String[]::new);
        }

        static MappingStrategy getByLabel(String label) {
            return Arrays.stream(MappingStrategy.values()).filter(m -> m.label.equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown label: " + label));
        }
    }
}

