/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location2.reverse;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.streamable.InputPortRole;
import org.knime.core.node.streamable.OutputPortRole;
import org.knime.core.node.streamable.PartitionInfo;
import org.knime.core.node.streamable.PortInput;
import org.knime.core.node.streamable.PortObjectInput;
import org.knime.core.node.streamable.PortOutput;
import org.knime.core.node.streamable.RowInput;
import org.knime.core.node.streamable.RowOutput;
import org.knime.core.node.streamable.StreamableOperator;
import ws.palladian.extraction.location.Location;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.extraction.location2.port.LocationSourcePortObject;
import ws.palladian.nodes.extraction.location2.reverse.ReverseLocationLookup2NodeSettings;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

public class ReverseLocationLookup2NodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ReverseLocationLookup2NodeModel.class);
    private final ReverseLocationLookup2NodeSettings nodeSettings = new ReverseLocationLookup2NodeSettings();
    static final int INPORT_CONNECTOR = 0;
    static final int INPORT_TABLE = 1;

    protected ReverseLocationLookup2NodeModel() {
        super(new PortType[]{LocationSourcePortObject.TYPE, BufferedDataTable.TYPE}, new PortType[]{BufferedDataTable.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inTable = (BufferedDataTable)inObjects[1];
        LocationSourcePortObject locationSource = (LocationSourcePortObject)inObjects[0];
        DataTableSpec inSpec = inTable.getSpec();
        MappingStrategy mappingStrategy = this.nodeSettings.getMappingStrategy();
        DataTableSpec outSpec = mappingStrategy.createSpec(inSpec, this.nodeSettings);
        BufferedDataContainer outTable = exec.createDataContainer(outSpec);
        String columnName = this.nodeSettings.settingCoordinateInputColumn.getStringValue();
        int inputIdx = inSpec.findColumnIndex(columnName);
        if (inputIdx < 0) {
            throw new IllegalStateException("Invalid input index: " + inputIdx);
        }
        double radius = this.nodeSettings.settingSearchRadius.getDoubleValue();
        int numLocations = this.nodeSettings.settingNumResults.getIntValue();
        LocationSource source = locationSource.getSpec().createSource();
        long inRowIndex = 0L;
        long inRowCount = inTable.size();
        for (DataRow inRow : inTable) {
            List<DataRow> rows = mappingStrategy.process(radius, numLocations, source, inRow, inputIdx);
            rows.forEach(arg_0 -> ((BufferedDataContainer)outTable).addRowToTable(arg_0));
            exec.checkCanceled();
            exec.setProgress((double)(++inRowIndex) / (double)inRowCount, "Processing row " + inRowIndex);
        }
        outTable.close();
        return new BufferedDataTable[]{outTable.getTable()};
    }

    protected void reset() {
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = (DataTableSpec)inSpecs[1];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.settingCoordinateInputColumn.getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.settingCoordinateInputColumn.getStringValue(), GeoCoordinateValue.class);
        } else {
            DataColumnSpec inColSpec = PalladianKnimeHelper.guessColumn(inSpec, GeoCoordinateValue.class);
            this.setWarningMessage("Guessing input column: " + inColSpec.getName());
            this.nodeSettings.settingCoordinateInputColumn.setStringValue(inColSpec.getName());
        }
        MappingStrategy mappingStrategy = this.nodeSettings.getMappingStrategy();
        return new DataTableSpec[]{mappingStrategy.createSpec(inSpec, this.nodeSettings)};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    public InputPortRole[] getInputPortRoles() {
        return new InputPortRole[]{InputPortRole.NONDISTRIBUTED_NONSTREAMABLE, InputPortRole.NONDISTRIBUTED_STREAMABLE};
    }

    public OutputPortRole[] getOutputPortRoles() {
        return new OutputPortRole[]{OutputPortRole.NONDISTRIBUTED};
    }

    public StreamableOperator createStreamableOperator(PartitionInfo partitionInfo, PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        PalladianPluginActivator.checkLicense();
        final MappingStrategy mappingStrategy = this.nodeSettings.getMappingStrategy();
        String columnName = this.nodeSettings.settingCoordinateInputColumn.getStringValue();
        DataTableSpec inSpec = (DataTableSpec)inSpecs[1];
        final int inputIdx = inSpec.findColumnIndex(columnName);
        if (inputIdx < 0) {
            throw new IllegalStateException("Invalid input index: " + inputIdx);
        }
        final double radius = this.nodeSettings.settingSearchRadius.getDoubleValue();
        final int numLocations = this.nodeSettings.settingNumResults.getIntValue();
        return new StreamableOperator(){

            public void runFinal(PortInput[] inputs, PortOutput[] outputs, ExecutionContext exec) throws Exception {
                PortObjectInput portObjectInput = (PortObjectInput)inputs[0];
                LocationSourcePortObject locationSourcePO = (LocationSourcePortObject)portObjectInput.getPortObject();
                RowInput rowInput = (RowInput)inputs[1];
                RowOutput rowOutput = (RowOutput)outputs[0];
                LocationSource source = locationSourcePO.getSpec().createSource();
                try {
                    DataRow row;
                    while ((row = rowInput.poll()) != null) {
                        exec.checkCanceled();
                        exec.setProgress("Processing row " + String.valueOf(row.getKey()));
                        List<DataRow> extractedRows = mappingStrategy.process(radius, numLocations, source, row, inputIdx);
                        for (DataRow extractedRow : extractedRows) {
                            rowOutput.push(extractedRow);
                        }
                    }
                    rowInput.close();
                    rowOutput.close();
                }
                finally {
                    if (source instanceof Closeable) {
                        ((Closeable)source).close();
                    }
                }
            }
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum MappingStrategy {
        ROWS("Rows"){

            @Override
            List<DataRow> map(DataRow inRow, List<Location> locations, int numLocations, GeoCoordinate coordinate) throws Exception {
                int currentAddedLocations = 0;
                long outRowIndex = 0L;
                ArrayList<DataRow> rows = new ArrayList<DataRow>();
                for (Location location : locations) {
                    LOGGER.debug((Object)("   Location = " + String.valueOf(location)));
                    ArrayList<Object> cells = new ArrayList<Object>();
                    cells.add(new StringCell(inRow.getKey().toString()));
                    cells.add(new IntCell(location.getId()));
                    cells.add(new StringCell(location.getPrimaryName()));
                    cells.add(CollectionCellFactory.createListCell((Collection)location.getAlternativeNames().stream().map(an -> new StringCell(an.getName())).collect(Collectors.toCollection(LinkedHashSet::new))));
                    cells.add(new StringCell(location.getType().toString()));
                    cells.add(location.getCoords().map(GeoCoordinateCell::new).orElse(DataType.getMissingCell()));
                    cells.add(Optional.ofNullable(location.getPopulation()).map(LongCell::new).orElse(DataType.getMissingCell()));
                    cells.add(CollectionCellFactory.createListCell((Collection)location.getAncestorIds().stream().map(IntCell::new).collect(Collectors.toList())));
                    cells.add(location.getCoords().map(l -> new DoubleCell(l.distance(coordinate))).orElse(DataType.getMissingCell()));
                    RowKey rowKey = new RowKey(inRow.getKey().getString() + "_" + outRowIndex++);
                    rows.add((DataRow)new AppendedColumnRow(rowKey, inRow, (DataCell[])cells.toArray(DataCell[]::new)));
                    if (++currentAddedLocations >= numLocations) break;
                }
                return rows;
            }

            @Override
            DataTableSpec createSpec(DataTableSpec inSpec, ReverseLocationLookup2NodeSettings settings) {
                String prefixString = Optional.ofNullable(settings.outputColumnPrefix.getStringValue()).orElse("");
                ArrayList<DataColumnSpec> spec = new ArrayList<DataColumnSpec>();
                spec.add(new DataColumnSpecCreator(prefixString + "RowID", StringCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location ID", IntCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Name", StringCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Alternative Names", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Type", StringCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Coordinates", GeoCoordinateCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Population", LongCell.TYPE).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Ancestor IDs", ListCell.getCollectionType((DataType)IntCell.TYPE)).createSpec());
                spec.add(new DataColumnSpecCreator(prefixString + "Location Distance", DoubleCell.TYPE).createSpec());
                return new DataTableSpec(inSpec, new DataTableSpec((DataColumnSpec[])spec.toArray(DataColumnSpec[]::new)));
            }
        }
        ,
        ROWS_OR_MISSING("Rows or Missing"){

            @Override
            List<DataRow> map(DataRow inRow, List<Location> locations, int numLocations, GeoCoordinate coordinate) throws Exception {
                if (locations.size() > 0) {
                    return ROWS.map(inRow, locations, numLocations, coordinate);
                }
                ArrayList<Object> cells = new ArrayList<Object>();
                cells.add(new StringCell(inRow.getKey().getString()));
                cells.addAll(Collections.nCopies(8, DataType.getMissingCell()));
                return Collections.singletonList(new AppendedColumnRow(inRow.getKey(), inRow, (DataCell[])cells.toArray(DataCell[]::new)));
            }

            @Override
            DataTableSpec createSpec(DataTableSpec inSpec, ReverseLocationLookup2NodeSettings settings) {
                return ROWS.createSpec(inSpec, settings);
            }
        }
        ,
        JSON("JSON"){

            @Override
            List<DataRow> map(DataRow inRow, List<Location> locations, int numLocations, GeoCoordinate coordinate) throws Exception {
                ObjectMapper mapper = new ObjectMapper();
                mapper.registerModule((Module)new Jdk8Module());
                mapper.setConfig((SerializationConfig)mapper.getSerializationConfig().with(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY}));
                String json = mapper.writeValueAsString(locations.stream().limit(numLocations).collect(Collectors.toList()));
                DataCell resultCell = JSONCellFactory.create((String)json, (boolean)false);
                return Collections.singletonList(new AppendedColumnRow(inRow.getKey(), inRow, new DataCell[]{resultCell}));
            }

            @Override
            DataTableSpec createSpec(DataTableSpec inSpec, ReverseLocationLookup2NodeSettings settings) {
                String prefixString = Optional.ofNullable(settings.outputColumnPrefix.getStringValue()).orElse("");
                return new DataTableSpec(inSpec, new DataTableSpec(new DataColumnSpec[]{new DataColumnSpecCreator(prefixString + "JSON", JSONCell.TYPE).createSpec()}));
            }
        };

        final String label;

        private MappingStrategy(String label) {
            this.label = label;
        }

        abstract List<DataRow> map(DataRow var1, List<Location> var2, int var3, GeoCoordinate var4) throws Exception;

        final List<DataRow> process(double radius, int numLocations, LocationSource source, DataRow inRow, int inputIdx) throws Exception {
            List locations;
            GeoCoordinateValue coordinate;
            DataCell cell = inRow.getCell(inputIdx);
            if (cell.isMissing()) {
                LOGGER.debug((Object)("Missing value in row " + String.valueOf(inRow.getKey())));
                coordinate = null;
                locations = Collections.emptyList();
            } else {
                coordinate = (GeoCoordinateValue)cell;
                LOGGER.debug((Object)("Coordinate = " + String.valueOf(coordinate)));
                locations = source.getLocations((GeoCoordinate)coordinate, radius);
            }
            return this.map(inRow, locations, numLocations, coordinate);
        }

        abstract DataTableSpec createSpec(DataTableSpec var1, ReverseLocationLookup2NodeSettings var2);

        static String[] getLabels() {
            return (String[])Arrays.stream(MappingStrategy.values()).map(m -> m.label).toArray(String[]::new);
        }

        static MappingStrategy getByLabel(String label) {
            return Arrays.stream(MappingStrategy.values()).filter(m -> m.label.equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown label: " + label));
        }
    }
}

