/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location2.source.geonames;

import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.ExecutionException;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.extraction.location.sources.GeonamesLocationSource;
import ws.palladian.helper.constants.Language;
import ws.palladian.nodes.extraction.location2.source.geonames.GeonamesLocationSourceNodeSettings;

class GeonamesLocationSourceNodeDialog
extends DefaultNodeSettingsPane {
    private static final String MESSAGE_LABEL_TEST_REQUEST = "Use the \u201cTest\u201d button to perform a test request on GeoNames.";
    private final GeonamesLocationSourceNodeSettings nodeSettings = new GeonamesLocationSourceNodeSettings();
    private final DialogComponentLabel messageLabel;

    GeonamesLocationSourceNodeDialog() {
        DialogComponentString usernameInput = new DialogComponentString(this.nodeSettings.username, "GeoNames Username", true, 15);
        this.addDialogComponent((DialogComponent)usernameInput);
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.nodeSettings.retrieveHierarchy, "Retrieve Location Hierarchy"));
        DialogComponentButton testButton = new DialogComponentButton("Test");
        this.addDialogComponent((DialogComponent)testButton);
        this.messageLabel = new DialogComponentLabel(MESSAGE_LABEL_TEST_REQUEST);
        this.addDialogComponent((DialogComponent)this.messageLabel);
        testButton.addActionListener(e -> {
            this.messageLabel.setText("Send test request \u2026");
            final JTextField textField = (JTextField)usernameInput.getComponentPanel().getComponent(1);
            SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() throws Exception {
                    return GeonamesLocationSourceNodeDialog.testGeonames(textField.getText());
                }

                @Override
                protected void done() {
                    try {
                        String msg = (String)this.get();
                        GeonamesLocationSourceNodeDialog.this.messageLabel.setText(msg);
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        GeonamesLocationSourceNodeDialog.this.messageLabel.setText("Error");
                    }
                }
            };
            worker.execute();
        });
    }

    private static String testGeonames(String username) {
        Collection locations;
        if (username == null || username.isBlank()) {
            return "Error: No username specified";
        }
        LocationSource source = GeonamesLocationSource.newCachedLocationSource((String)username);
        try {
            locations = source.getLocations("new york", EnumSet.of(Language.ENGLISH));
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (locations.isEmpty()) {
            return "Error: Source did not return any locations for test request.";
        }
        return "Test successful.";
    }
}

