/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location2.source.local;

import java.io.File;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.extraction.location.persistence.lucene.LuceneLocationSource;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location2.source.local.LocalLocationSourcePortObjectSpec;

class LocalLocationSourceNodeSettings {
    static final String KEY_DIRECTORY_PATH = "directoryPath";
    final SettingsModelString directoryPath = new SettingsModelString("directoryPath", null);

    LocalLocationSourceNodeSettings() {
    }

    void saveSettings(NodeSettingsWO settings) {
        this.directoryPath.saveSettingsTo(settings);
    }

    void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.directoryPath.loadSettingsFrom(settings);
    }

    void validateSettings() throws InvalidSettingsException {
        int numLocations;
        String pathToDirectory = this.directoryPath.getStringValue();
        if (StringUtils.nullOrEmpty(pathToDirectory)) {
            throw new InvalidSettingsException("Please specify a path to an existing directory.");
        }
        File directory = new File(pathToDirectory);
        if (!directory.isDirectory()) {
            throw new InvalidSettingsException("The directory with path " + String.valueOf(directory) + " does not exist or is not a directory.");
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (LuceneLocationSource source = new LocalLocationSourcePortObjectSpec(this).createSource();){
                numLocations = source.size();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new InvalidSettingsException("Could not read the location source at " + String.valueOf(directory) + ": " + e.getMessage(), (Throwable)e);
        }
        if (numLocations < 1) {
            throw new InvalidSettingsException("The location source is empty.");
        }
    }
}

