/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.ngram;

import java.util.ArrayList;
import java.util.Iterator;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.classification.text.FeatureSetting;
import ws.palladian.classification.text.Preprocessor;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.ngram.NGramExtractorNodeSettings;

public class NGramExtractorNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final NGramExtractorNodeSettings nodeSettings = new NGramExtractorNodeSettings();

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        final int inputIdx = spec.findColumnIndex(this.nodeSettings.textColumn.getStringValue());
        FeatureSetting featureSetting = this.nodeSettings.featureSettingsConfig.getFeatureSetting();
        final Preprocessor preprocessor = new Preprocessor(featureSetting);
        String featureSettingDescription = featureSetting.toString().replaceAll(".*\\[", "").replaceAll("\\]$", "");
        Object appendedColumnName = StringUtils.notNullOrEmpty(this.nodeSettings.outputColumn.getStringValue()) ? this.nodeSettings.outputColumn.getStringValue() : this.nodeSettings.textColumn.getStringValue() + " (" + featureSettingDescription + ")";
        DataColumnSpec appendedColumnSpec = new DataColumnSpecCreator((String)appendedColumnName, ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec();
        SingleCellFactory cellFactory = new SingleCellFactory(true, appendedColumnSpec){

            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(inputIdx);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                String text = ((StringValue)inputCell).getStringValue();
                Iterator tokens = preprocessor.apply(text);
                ArrayList tokenList = new ArrayList();
                tokens.forEachRemaining(s -> {
                    boolean bl = tokenList.add(new StringCell(s));
                });
                return CollectionCellFactory.createListCell(tokenList);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        if (this.nodeSettings.dropTextColumn.getBooleanValue()) {
            rearranger.remove(new String[]{this.nodeSettings.textColumn.getStringValue()});
        }
        return rearranger;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }
}

