/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.regex;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.philippkatz.regextractor.RegexTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import ws.palladian.nodes.PalladianPluginActivator;

public final class RegexExtractorTemplateSettings {
    private static final String PREF_KEY = "regexTemplates";
    private static final List<RegexTemplate> PRESET_TEMPLATES = RegexExtractorTemplateSettings.readPresetTemplates("presetTemplates.json");
    @JsonDeserialize(contentAs=JsonRegexTemplate.class)
    public final List<? extends RegexTemplate> templates;

    public static List<? extends RegexTemplate> load() {
        String json = PalladianPluginActivator.getDefault().getPreferenceStore().getString(PREF_KEY);
        ArrayList<RegexTemplate> templates = new ArrayList<RegexTemplate>(PRESET_TEMPLATES);
        templates.addAll(RegexExtractorTemplateSettings.parseJson(json));
        templates.sort(Comparator.comparing(RegexTemplate::getName));
        return Collections.unmodifiableList(templates);
    }

    public static void save(List<? extends RegexTemplate> templates) {
        List templatesToSave = templates.stream().filter(template -> !template.isReadonly()).collect(Collectors.toList());
        try {
            String json = new ObjectMapper().writeValueAsString((Object)new RegexExtractorTemplateSettings(templatesToSave));
            PalladianPluginActivator.getDefault().getPreferenceStore().setValue(PREF_KEY, json);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public RegexExtractorTemplateSettings(@JsonProperty(value="templates") List<? extends RegexTemplate> templates) {
        this.templates = templates;
    }

    private static List<RegexTemplate> readPresetTemplates(String resourceName) {
        String json = RegexExtractorTemplateSettings.readResourceToString(resourceName);
        return RegexExtractorTemplateSettings.parseJson(json).stream().map(template -> new RegexTemplate(template.getName(), template.getRegex(), template.getFlags(), true)).collect(Collectors.toList());
    }

    private static List<? extends RegexTemplate> parseJson(String json) {
        try {
            return ((RegexExtractorTemplateSettings)new ObjectMapper().readValue((String)json, RegexExtractorTemplateSettings.class)).templates;
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    private static String readResourceToString(String name) {
        InputStream inputStream = RegexExtractorTemplateSettings.class.getResourceAsStream(name);
        if (inputStream == null) {
            throw new IllegalStateException(name + " not found.");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static class JsonRegexTemplate
    extends RegexTemplate {
        JsonRegexTemplate(@JsonProperty(value="name") String name, @JsonProperty(value="regex") String regex, @JsonProperty(value="flags") int flags) {
            super(name, regex, flags);
        }
    }
}

