/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.geo.openlocationcode.creator;

import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.geo.openlocationcode.creator.OpenLocationCodeCreatorSettings;

class OpenLocationCodeCreatorNodeDialog
extends DefaultNodeSettingsPane {
    private final OpenLocationCodeCreatorSettings nodeSettings = new OpenLocationCodeCreatorSettings();

    OpenLocationCodeCreatorNodeDialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.nodeSettings.inputColumn, "Input", 0, new Class[]{GeoCoordinateValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.nodeSettings.dropInputColumn, "Drop input column"));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.nodeSettings.codeLength, "Code length", (Number)1));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.outputColumn, "Output column name", false, 15));
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        int codeLength = this.nodeSettings.codeLength.getIntValue();
        if (codeLength < 4) {
            throw new InvalidSettingsException("Code length must be at least 4");
        }
        if (codeLength < 10 && codeLength % 2 != 0) {
            throw new InvalidSettingsException("Below 10, only even code lengths are allowed");
        }
        if (codeLength > 15) {
            throw new InvalidSettingsException("Code length must not be greater than 15");
        }
    }
}

