/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.base64.decoder;

import java.io.IOException;
import java.util.Base64;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.DataValue;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectCellFactory;
import org.knime.core.data.blob.BinaryObjectDataCell;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.base64.decoder.Base64DecoderNodeSettings;

class Base64DecoderNodeModel
extends SimpleStreamableFunctionNodeModel {
    static final Class<? extends DataValue> INPUT_TYPE = StringValue.class;
    private final Base64DecoderNodeSettings nodeSettings = new Base64DecoderNodeSettings();
    private BinaryObjectCellFactory binaryCellFactory;

    Base64DecoderNodeModel() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        this.binaryCellFactory = new BinaryObjectCellFactory(exec);
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        String inputColumnName = this.nodeSettings.getSettingInputColumn().getStringValue();
        final int inputColumnIdx = spec.findColumnIndex(inputColumnName);
        Object outputColumnName = StringUtils.notNullOrEmpty(this.nodeSettings.getSettingOutputColumn().getStringValue()) ? this.nodeSettings.getSettingOutputColumn().getStringValue() : inputColumnName + " (decoded)";
        final boolean decodeToString = this.nodeSettings.getSettingDecodeToString().getBooleanValue();
        DataType outType = decodeToString ? StringCell.TYPE : BinaryObjectDataCell.TYPE;
        DataColumnSpec newColSpec = new DataColumnSpecCreator((String)outputColumnName, outType).createSpec();
        SingleCellFactory factory = new SingleCellFactory(true, newColSpec){

            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(inputColumnIdx);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                StringValue stringValue = (StringValue)inputCell;
                try {
                    byte[] decoded = Base64DecoderNodeModel.decodeBase64(stringValue.getStringValue());
                    if (decodeToString) {
                        return new StringCell(new String(decoded));
                    }
                    return Base64DecoderNodeModel.this.binaryCellFactory.create(decoded);
                }
                catch (IOException iOException) {
                    return DataType.getMissingCell();
                }
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(spec);
        columnRearranger.append((CellFactory)factory);
        if (this.nodeSettings.getSettingRemoveInputColumn().getBooleanValue()) {
            columnRearranger.remove(new int[]{inputColumnIdx});
        }
        return columnRearranger;
    }

    private static byte[] decodeBase64(String base64) throws IOException {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.getSettingInputColumn().getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.getSettingInputColumn().getStringValue(), INPUT_TYPE);
        } else {
            DataColumnSpec columnSpec = PalladianKnimeHelper.guessColumn(inSpec, INPUT_TYPE);
            this.setWarningMessage("Guessed input column: " + columnSpec.getName());
            this.nodeSettings.getSettingInputColumn().setStringValue(columnSpec.getName());
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    protected void reset() {
        this.binaryCellFactory = null;
    }
}

