/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.base64.encoder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.Optional;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.DataValue;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.knime.core.util.FileUtil;
import org.knime.filehandling.core.connections.FSLocationSpec;
import org.knime.filehandling.core.connections.location.FSPathProvider;
import org.knime.filehandling.core.connections.location.FSPathProviderFactory;
import org.knime.filehandling.core.connections.uriexport.noconfig.NoConfigURIExporterFactory;
import org.knime.filehandling.core.data.location.FSLocationValue;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.base64.Base64NodeSettings;

@Deprecated
class Base64EncoderNodeModel
extends SimpleStreamableFunctionNodeModel {
    static final Class<? extends DataValue>[] INPUT_TYPES = new Class[]{BinaryObjectDataValue.class, StringValue.class};
    private final Base64NodeSettings nodeSettings = new Base64NodeSettings();

    Base64EncoderNodeModel() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        String inputColumnName = this.nodeSettings.getSettingInputColumn().getStringValue();
        final int inputColumnIdx = spec.findColumnIndex(inputColumnName);
        Object outputColumnName = StringUtils.notNullOrEmpty(this.nodeSettings.getSettingOutputColumn().getStringValue()) ? this.nodeSettings.getSettingOutputColumn().getStringValue() : inputColumnName + " (encoded)";
        DataColumnSpec newColSpec = new DataColumnSpecCreator((String)outputColumnName, StringCell.TYPE).createSpec();
        SingleCellFactory factory = new SingleCellFactory(true, newColSpec){

            /*
             * Loose catch block
             */
            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(inputColumnIdx);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                if (inputCell.getType().isCompatible(BinaryObjectDataValue.class)) {
                    BinaryObjectDataValue binaryObject = (BinaryObjectDataValue)inputCell;
                    try {
                        Throwable throwable = null;
                        Object var5_10 = null;
                        try (InputStream inputStream = binaryObject.openInputStream();){
                            String base64 = Base64EncoderNodeModel.encodeBase64(inputStream);
                            return new StringCell(base64);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        return DataType.getMissingCell();
                    }
                }
                if (inputCell.getType().isCompatible(FSLocationValue.class)) {
                    FSLocationValue fsLocationValue = (FSLocationValue)inputCell;
                    try {
                        Throwable throwable = null;
                        Object var5_12 = null;
                        try (FSPathProviderFactory ppFactory = FSPathProviderFactory.newFactory(Optional.empty(), (FSLocationSpec)fsLocationValue.getFSLocation());){
                            StringCell stringCell;
                            FSPathProvider pathProvider;
                            Throwable throwable3;
                            block36: {
                                throwable3 = null;
                                Object var8_19 = null;
                                pathProvider = ppFactory.create(fsLocationValue.getFSLocation());
                                NoConfigURIExporterFactory uriExporterFactory = pathProvider.getFSConnection().getDefaultURIExporterFactory();
                                URI uri = uriExporterFactory.getExporter().toUri(pathProvider.getPath());
                                File file = FileUtil.getFileFromURL((URL)uri.toURL());
                                FileInputStream inputStream = new FileInputStream(file);
                                String base64 = Base64EncoderNodeModel.encodeBase64(inputStream);
                                stringCell = new StringCell(base64);
                                if (pathProvider == null) break block36;
                                pathProvider.close();
                            }
                            return stringCell;
                            {
                                catch (Throwable throwable4) {
                                    try {
                                        if (pathProvider != null) {
                                            pathProvider.close();
                                        }
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable3 == null) {
                                            throwable3 = throwable5;
                                        } else if (throwable3 != throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        throw throwable3;
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                            } else if (throwable != throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | URISyntaxException exception) {
                        return DataType.getMissingCell();
                    }
                }
                if (inputCell.getType().isCompatible(StringValue.class)) {
                    StringValue stringValue = (StringValue)inputCell;
                    return new StringCell(Base64.getEncoder().encodeToString(stringValue.getStringValue().getBytes()));
                }
                return DataType.getMissingCell();
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(spec);
        columnRearranger.append((CellFactory)factory);
        if (this.nodeSettings.getSettingRemoveInputColumn().getBooleanValue()) {
            columnRearranger.remove(new int[]{inputColumnIdx});
        }
        return columnRearranger;
    }

    private static String encodeBase64(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            int nRead;
            byte[] buffer = new byte[1024];
            while ((nRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
                stream.write(buffer, 0, nRead);
            }
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(stream.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.getSettingInputColumn().getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.getSettingInputColumn().getStringValue(), INPUT_TYPES);
        } else {
            DataColumnSpec columnSpec = PalladianKnimeHelper.guessColumn(inSpec, INPUT_TYPES);
            this.setWarningMessage("Guessed input column: " + columnSpec.getName());
            this.nodeSettings.getSettingInputColumn().setStringValue(columnSpec.getName());
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }
}

