/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.decryptPassword;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.MissingCell;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.decryptPassword.DecryptPasswordFromWorkflowNodeSettings;
import ws.palladian.nodes.helper.decryptPassword.Decryptor;

class DecryptPasswordFromWorkflowNodeModel
extends NodeModel {
    private final DecryptPasswordFromWorkflowNodeSettings nodeSettings = new DecryptPasswordFromWorkflowNodeSettings();
    private static final Pattern XPASSWORD_ENTRY_PATTERN = Pattern.compile("<entry key=\"(?<key>.*?)\" type=\"xpassword\" value=\"(?<value>.*?)\"\\/>");

    DecryptPasswordFromWorkflowNodeModel() {
        super(0, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        this.nodeSettings.validateSettings();
        return new DataTableSpec[]{DecryptPasswordFromWorkflowNodeModel.createSpec()};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        this.nodeSettings.validateSettings();
        BufferedDataContainer container = exec.createDataContainer(DecryptPasswordFromWorkflowNodeModel.createSpec());
        Path tempDirectory = Files.createTempDirectory("knimeDecryptPasswordNode_", new FileAttribute[0]);
        String workflowFile = this.nodeSettings.workflowFileModel.getStringValue();
        Path workflowPath = PalladianKnimeHelper.getFileFromUrlOrPath(workflowFile).toPath();
        DecryptPasswordFromWorkflowNodeModel.extractZipFile(workflowPath, tempDirectory);
        AtomicLong outIdx = new AtomicLong(-1L);
        Throwable throwable = null;
        Object var9_10 = null;
        try (Stream<Path> stream = Files.walk(tempDirectory, new FileVisitOption[0]);){
            stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.getFileName().endsWith("settings.xml")).forEach(path2 -> {
                try {
                    String xmlFileContent = Files.readString(path2);
                    Matcher matcher = XPASSWORD_ENTRY_PATTERN.matcher(xmlFileContent);
                    RowKey rowKey = RowKey.createRowKey((long)outIdx.incrementAndGet());
                    StringCell filePathCell = new StringCell(path2.toString().replace(tempDirectory.toString() + "/", ""));
                    while (matcher.find()) {
                        MissingCell decryptedValue;
                        StringCell keyCell = new StringCell(matcher.group("key"));
                        String encryptedValue = matcher.group("value");
                        try {
                            decryptedValue = new StringCell(Decryptor.tryDecrypt(encryptedValue, this.nodeSettings.encryptionKeyModel.getStringValue()));
                        }
                        catch (Exception e) {
                            decryptedValue = new MissingCell(e.getMessage());
                        }
                        container.addRowToTable((DataRow)new DefaultRow(rowKey, new DataCell[]{filePathCell, keyCell, new StringCell(encryptedValue), decryptedValue}));
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        container.close();
        return new BufferedDataTable[]{container.getTable()};
    }

    private static DataTableSpec createSpec() {
        return new DataTableSpecCreator().addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("file", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("entryKey", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("encryptedValue", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("decryptedValue", StringCell.TYPE).createSpec()}).createSpec();
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    protected void reset() {
    }

    private static void extractZipFile(Path zipFile, Path targetDirectory) throws IOException {
        Files.createDirectories(targetDirectory, new FileAttribute[0]);
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zip = new ZipFile(zipFile.toFile());){
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                Path destFile = Paths.get(targetDirectory.toString(), entry.getName());
                Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                if (entry.isDirectory()) continue;
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));){
                    Files.copy(is, destFile, new CopyOption[0]);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

