/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.dist2;

import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.DataValue;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.ColumnFilter;
import org.knime.distance.DistanceMeasurePortSpec;
import org.knime.distance.DistanceMeasureValidationException;
import ws.palladian.nodes.helper.dist2.ColumnDistance2NodeModel;
import ws.palladian.nodes.helper.dist2.ColumnDistance2Settings;

class ColumnDistance2NodeDialog
extends DefaultNodeSettingsPane {
    private final ColumnDistance2Settings nodeSettings = new ColumnDistance2Settings();
    private final DialogComponentColumnNameSelection columnSelection;

    ColumnDistance2NodeDialog() {
        this.columnSelection = new DialogComponentColumnNameSelection(this.nodeSettings.secondInputColumn, "Second input column", 0, new Class[]{DataValue.class});
        this.addDialogComponent((DialogComponent)this.columnSelection);
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        DataTableSpec tableSpec = (DataTableSpec)specs[0];
        DistanceMeasurePortSpec distancePortSpec = (DistanceMeasurePortSpec)specs[1];
        try {
            distancePortSpec.validate(tableSpec);
        }
        catch (DistanceMeasureValidationException e) {
            throw new NotConfigurableException(e.getMessage());
        }
        if (distancePortSpec.getColumnNames().size() != 1) {
            throw new NotConfigurableException("This node only works for distance measures with one input column.");
        }
        final String columnName = ColumnDistance2NodeModel.getFirst(distancePortSpec.getColumnNames());
        final DataColumnSpec columnSpec = tableSpec.getColumnSpec(columnName);
        this.columnSelection.setColumnFilter(new ColumnFilter(){

            public boolean includeColumn(DataColumnSpec colSpec) {
                if (colSpec.getName().equals(columnName)) {
                    return false;
                }
                DataType dataType = colSpec.getType();
                return dataType.equals((Object)columnSpec.getType());
            }

            public String allFilteredMsg() {
                return "No suitable columns found";
            }
        });
        super.loadAdditionalSettingsFrom(settings, specs);
    }
}

