/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.hash;

import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.helper.nlp.StringHelper;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.hash.HashCalculatorNodeDialog;

public class HashCalculatorNodeModel
extends NodeModel {
    static final String CFGKEY_HASH_ALGORITHM = "hashAlgorithm";
    static final String CFGKEY_INPUT_COLUMN = "inputColumn";
    static final String SHA1_ALGORITHM = "SHA1";
    static final String[] HASH_ALGORITHMS = new String[]{"SHA1"};
    private final SettingsModelString settingInputColumn = HashCalculatorNodeDialog.createSettingsModelInputColumn();
    private final SettingsModelString settingHashAlgorithm = HashCalculatorNodeDialog.createSettingsModelHashAlgorithm();

    protected HashCalculatorNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        ColumnRearranger columnRearranger = this.createColumnRearranger(inData[0].getSpec());
        BufferedDataTable outputTable = exec.createColumnRearrangeTable(inData[0], columnRearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{outputTable};
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec) {
        final String hashAlgorithm = this.settingHashAlgorithm.getStringValue();
        String inputColumnName = this.settingInputColumn.getStringValue();
        final int inputColumnIdx = dataTableSpec.findColumnIndex(inputColumnName);
        DataColumnSpec newColSpec = new DataColumnSpecCreator(inputColumnName + " (" + hashAlgorithm + ")", StringCell.TYPE).createSpec();
        SingleCellFactory factory = new SingleCellFactory(true, newColSpec){

            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(inputColumnIdx);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                if (!hashAlgorithm.equals(HashCalculatorNodeModel.SHA1_ALGORITHM)) {
                    throw new IllegalStateException("Unimplemented hash algorithm: " + hashAlgorithm);
                }
                String inputString = ((StringValue)inputCell).getStringValue();
                String hash = StringHelper.sha1((String)inputString);
                return new StringCell(hash);
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(dataTableSpec);
        columnRearranger.append((CellFactory)factory);
        return columnRearranger;
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingInputColumn.getStringValue(), StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessed input column: " + columnName);
            this.settingInputColumn.setStringValue(columnName);
        }
        ColumnRearranger columnRearranger = this.createColumnRearranger(inSpec);
        return new DataTableSpec[]{columnRearranger.createSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingHashAlgorithm.saveSettingsTo(settings);
        this.settingInputColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingHashAlgorithm.loadSettingsFrom(settings);
        this.settingInputColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingHashAlgorithm.validateSettings(settings);
        this.settingInputColumn.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

