/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.hash2;

import java.security.MessageDigest;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ws.palladian.nodes.ExtensionPointUtil;
import ws.palladian.nodes.helper.hash2.HashAlgorithm;
import ws.palladian.nodes.helper.hash2.HashAlgorithmProvider;
import ws.palladian.nodes.helper.hash2.MessageDigestHashAlgorithm;

public final class HashAlgorithms {
    private static final List<HashAlgorithm> HASH_ALGORITHMS;
    private static final String EXTENSION_POINT_ID = "ws.palladian.nodes.HashAlgorithmProvider";
    private static final String PROVIDER_CLASS = "providerClass";

    static {
        ArrayList<? extends HashAlgorithm> hashAlgos = new ArrayList<HashAlgorithm>();
        hashAlgos.addAll(HashAlgorithms.loadFromProviders());
        List<HashAlgorithmProvider> providers = ExtensionPointUtil.loadExtensions(EXTENSION_POINT_ID, PROVIDER_CLASS);
        providers.forEach(p -> {
            boolean bl = hashAlgos.addAll(p.getHashAlgos());
        });
        HASH_ALGORITHMS = Collections.unmodifiableList(hashAlgos);
    }

    public static List<HashAlgorithm> getAll() {
        return HASH_ALGORITHMS;
    }

    public static List<String> getProviders() {
        return HASH_ALGORITHMS.stream().map(a -> a.getProvider()).distinct().sorted().collect(Collectors.toList());
    }

    public static List<HashAlgorithm> getForProvider(String provider) {
        return HASH_ALGORITHMS.stream().filter(a -> a.getProvider().equals(provider)).collect(Collectors.toList());
    }

    private static List<? extends HashAlgorithm> loadFromProviders() {
        return Arrays.stream(Security.getProviders()).flatMap(provider -> provider.getServices().stream()).filter(service -> service.getType().equalsIgnoreCase(MessageDigest.class.getSimpleName())).map(MessageDigestHashAlgorithm::new).collect(Collectors.toList());
    }

    public static HashAlgorithm get(String identifier, String provider) {
        return HASH_ALGORITHMS.stream().filter(a -> a.getIdentifier().equals(identifier) && a.getProvider().equals(provider)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No hash algorithm %s from provider %s", identifier, provider)));
    }

    private HashAlgorithms() {
    }
}

