/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.hash2;

import java.util.List;
import java.util.stream.Collectors;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import ws.palladian.nodes.helper.hash2.HashAlgorithm;
import ws.palladian.nodes.helper.hash2.HashAlgorithms;
import ws.palladian.nodes.helper.hash2.HashCalculator2NodeSettings;

class HashCalculator2NodeDialog
extends DefaultNodeSettingsPane {
    private final HashCalculator2NodeSettings nodeSettings = new HashCalculator2NodeSettings();
    private final DialogComponentStringSelection algoSelection;

    protected HashCalculator2NodeDialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.nodeSettings.getSettingInputColumn(), "Input", 0, (Class[])HashCalculator2NodeSettings.INPUT_TYPES));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.nodeSettings.getSettingRemoveInputColumn(), "Remove input column"));
        DialogComponentStringSelection providerSelection = new DialogComponentStringSelection(this.nodeSettings.getSettingHashProvider(), "Provider", HashAlgorithms.getProviders());
        providerSelection.getModel().addChangeListener(e -> this.updateAlgoSelection());
        this.addDialogComponent((DialogComponent)providerSelection);
        this.algoSelection = new DialogComponentStringSelection(this.nodeSettings.getSettingHashAlgorithm(), "Algorithm", HashCalculator2NodeDialog.getSortedNames(HashAlgorithms.getAll()));
        this.addDialogComponent((DialogComponent)this.algoSelection);
    }

    public void onOpen() {
        this.updateAlgoSelection();
    }

    private void updateAlgoSelection() {
        String provider = this.nodeSettings.getSettingHashProvider().getStringValue();
        List<String> algoNames = HashCalculator2NodeDialog.getSortedNames(HashAlgorithms.getForProvider(provider));
        this.algoSelection.replaceListItems(algoNames, null);
    }

    private static List<String> getSortedNames(List<HashAlgorithm> algos) {
        return algos.stream().map(a -> a.getIdentifier()).sorted().collect(Collectors.toList());
    }
}

