/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.hash2;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Objects;
import ws.palladian.nodes.helper.hash2.HashAlgorithm;

public final class MessageDigestHashAlgorithm
implements HashAlgorithm {
    private final Provider.Service service;

    public MessageDigestHashAlgorithm(Provider.Service service) {
        this.service = Objects.requireNonNull(service, "service was null");
    }

    @Override
    public String hash(InputStream input) throws IOException {
        MessageDigest messageDigest;
        Objects.requireNonNull(input, "input was null");
        try {
            messageDigest = MessageDigest.getInstance(this.service.getAlgorithm(), this.service.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        DigestInputStream digestInputStream = new DigestInputStream(input, messageDigest);
        while (digestInputStream.read() != -1) {
        }
        digestInputStream.close();
        byte[] digestBytes = messageDigest.digest();
        return MessageDigestHashAlgorithm.convertToHex(digestBytes);
    }

    @Override
    public String getIdentifier() {
        return this.service.getAlgorithm();
    }

    @Override
    public String getProvider() {
        return this.service.getProvider().getName();
    }

    private static String convertToHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            builder.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            ++n2;
        }
        return builder.toString();
    }
}

