/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.mimetype;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.tika.Tika;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.MissingCell;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.uri.URIDataValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.knime.core.util.FileUtil;
import org.knime.filehandling.core.connections.FSLocationSpec;
import org.knime.filehandling.core.connections.location.FSPathProvider;
import org.knime.filehandling.core.connections.location.FSPathProviderFactory;
import org.knime.filehandling.core.connections.uriexport.noconfig.NoConfigURIExporterFactory;
import org.knime.filehandling.core.data.location.FSLocationValue;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.mimetype.MimeTypeExtractorNodeSettings;

class MimeTypeExtractorNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final MimeTypeExtractorNodeSettings nodeSettings = new MimeTypeExtractorNodeSettings();

    MimeTypeExtractorNodeModel() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec) throws InvalidSettingsException {
        String inputColumnName = this.nodeSettings.getSettingInputColumn().getStringValue();
        final int inputColumnIdx = dataTableSpec.findColumnIndex(inputColumnName);
        DataColumnSpec newColSpec = new DataColumnSpecCreator(inputColumnName + " (MIME type)", StringCell.TYPE).createSpec();
        SingleCellFactory factory = new SingleCellFactory(true, newColSpec){

            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(inputColumnIdx);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream inputStream = MimeTypeExtractorNodeModel.getInput(inputCell);){
                        String mimeType = MimeTypeExtractorNodeModel.detectMimeType(new BufferedInputStream(inputStream));
                        return new StringCell(mimeType);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | URISyntaxException e) {
                    return new MissingCell(e.getMessage());
                }
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(dataTableSpec);
        columnRearranger.append((CellFactory)factory);
        return columnRearranger;
    }

    /*
     * Loose catch block
     */
    private static InputStream getInput(DataCell cell) throws IOException, URISyntaxException {
        if (cell.getType().isCompatible(BinaryObjectDataValue.class)) {
            BinaryObjectDataValue binaryObject = (BinaryObjectDataValue)cell;
            return binaryObject.openInputStream();
        }
        if (cell.getType().isCompatible(URIDataValue.class)) {
            URIDataValue uriValue = (URIDataValue)cell;
            URI uri = uriValue.getURIContent().getURI();
            File file = FileUtil.getFileFromURL((URL)uri.toURL());
            return new FileInputStream(file);
        }
        if (cell.getType().isCompatible(StringValue.class)) {
            String inputString = ((StringValue)cell).getStringValue();
            byte[] bytes = inputString.getBytes(StandardCharsets.UTF_8);
            return new ByteArrayInputStream(bytes);
        }
        if (cell.getType().isCompatible(FSLocationValue.class)) {
            FSLocationValue fsLocationValue = (FSLocationValue)cell;
            Throwable throwable = null;
            Object var3_10 = null;
            try (FSPathProviderFactory ppFactory = FSPathProviderFactory.newFactory(Optional.empty(), (FSLocationSpec)fsLocationValue.getFSLocation());){
                FileInputStream fileInputStream;
                FSPathProvider pathProvider;
                Throwable throwable2;
                block23: {
                    throwable2 = null;
                    Object var6_15 = null;
                    pathProvider = ppFactory.create(fsLocationValue.getFSLocation());
                    NoConfigURIExporterFactory uriExporterFactory = pathProvider.getFSConnection().getDefaultURIExporterFactory();
                    URI uri = uriExporterFactory.getExporter().toUri(pathProvider.getPath());
                    File file = FileUtil.getFileFromURL((URL)uri.toURL());
                    fileInputStream = new FileInputStream(file);
                    if (pathProvider == null) break block23;
                    pathProvider.close();
                }
                return fileInputStream;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (pathProvider != null) {
                                pathProvider.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(cell.getType()));
    }

    private static String detectMimeType(InputStream stream) throws IOException {
        return new Tika().detect(stream);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.getSettingInputColumn().getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.getSettingInputColumn().getStringValue(), MimeTypeExtractorNodeSettings.INPUT_TYPES);
        } else {
            DataColumnSpec columnSpec = PalladianKnimeHelper.guessColumn(inSpec, MimeTypeExtractorNodeSettings.INPUT_TYPES);
            this.setWarningMessage("Guessed input column: " + columnSpec.getName());
            this.nodeSettings.getSettingInputColumn().setStringValue(columnSpec.getName());
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }
}

