/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.testing;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.testing.PreferencesSettings;

class EclipsePreferencesNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(EclipsePreferencesNodeModel.class);
    private PreferencesSettings settings = new PreferencesSettings();

    protected EclipsePreferencesNodeModel() {
        super(0, 0);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        int i = 0;
        while (i < this.settings.getKeys().length) {
            String settingKey = this.settings.getKeys()[i];
            String settingValue = this.settings.getValues()[i];
            IPreferenceStore prefStore = PalladianPluginActivator.getDefault().getPreferenceStore();
            LOGGER.debug((Object)("set " + settingKey + " = " + settingValue));
            prefStore.setValue(settingKey, settingValue);
            ++i;
        }
        return new BufferedDataTable[0];
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[0];
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        new PreferencesSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settings = new PreferencesSettings(settings);
    }

    protected void reset() {
    }
}

