/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.url;

import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.helper.UrlHelper;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.url.UrlDomainExtractorNodeDialog;

public class UrlDomainExtractorNodeModel
extends SimpleStreamableFunctionNodeModel {
    public static final String CFGKEY_INPUT_COLUMN = "inputColumn";
    public static final String CFGKEY_INCLUDE_PROTOCOL = "includeProtocol";
    public static final String CFGKEY_INCLUDE_SUBDOMAIN = "includeSubdomain";
    private final SettingsModelString settingInputColumn = UrlDomainExtractorNodeDialog.createSettingsInputColumn();
    private final SettingsModelBoolean settingIncludeProtocol = UrlDomainExtractorNodeDialog.createSettingsIncludeProtocol();
    private final SettingsModelBoolean settingIncludeSubdomain = UrlDomainExtractorNodeDialog.createSettingsInputSubdomain();

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingInputColumn.getStringValue(), StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingInputColumn.setStringValue(columnName);
        }
        return super.configure(inSpecs);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        DataColumnSpec domainColSpec = new DataColumnSpecCreator("Extracted domain", StringCell.TYPE).createSpec();
        final int inColumnIndex = spec.findColumnIndex(this.settingInputColumn.getStringValue());
        final boolean includeProtocol = this.settingIncludeProtocol.getBooleanValue();
        final boolean includeSubdomain = this.settingIncludeSubdomain.getBooleanValue();
        SingleCellFactory factory = new SingleCellFactory(domainColSpec){

            public DataCell getCell(DataRow row) {
                DataCell inCell = row.getCell(inColumnIndex);
                if (inCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                String url = ((StringValue)inCell).getStringValue();
                if (url == null || url.isEmpty()) {
                    return DataType.getMissingCell();
                }
                String domain = UrlHelper.getDomain((String)url, (boolean)includeProtocol, (boolean)includeSubdomain);
                return new StringCell(domain);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
        this.settingIncludeProtocol.saveSettingsTo(settings);
        this.settingIncludeSubdomain.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
        this.settingIncludeProtocol.validateSettings(settings);
        this.settingIncludeSubdomain.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
        this.settingIncludeProtocol.loadSettingsFrom(settings);
        this.settingIncludeSubdomain.loadSettingsFrom(settings);
    }
}

