/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.url;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.helper.UrlHelper;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.url.UrlExtractorNodeDialog;

public class UrlExtractorNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(UrlExtractorNodeModel.class);
    static final String CFGKEY_TEXT_COLUMN = "textColumn";
    private final SettingsModelString settingTextColumn = UrlExtractorNodeDialog.createSettingsTextColumnName();

    protected UrlExtractorNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inputTable = inData[0];
        DataTableSpec inputSpec = inputTable.getDataTableSpec();
        DataTableSpec outputSpec = this.getOutputSpec(inputSpec);
        BufferedDataContainer outputContainer = exec.createDataContainer(outputSpec);
        long outputRowIndex = 0L;
        long inputRowIndex = 0L;
        long rowCount = inputTable.size();
        int textColumnIndex = inputSpec.findColumnIndex(this.settingTextColumn.getStringValue());
        assert (textColumnIndex != -1);
        for (DataRow dataRow : inputTable) {
            ++inputRowIndex;
            DataCell textCell = dataRow.getCell(textColumnIndex);
            if (textCell.isMissing()) {
                outputContainer.addRowToTable((DataRow)new AppendedColumnRow(RowKey.createRowKey((long)outputRowIndex++), dataRow, new DataCell[]{DataType.getMissingCell()}));
                logger.debug((Object)("no text in " + inputRowIndex));
                continue;
            }
            String text = ((StringValue)textCell).getStringValue();
            List urls = UrlHelper.extractUrls((String)text);
            if (urls.isEmpty()) {
                outputContainer.addRowToTable((DataRow)new AppendedColumnRow(RowKey.createRowKey((long)outputRowIndex++), dataRow, new DataCell[]{DataType.getMissingCell()}));
                logger.debug((Object)("no URLs found in " + inputRowIndex));
                continue;
            }
            logger.debug((Object)(urls.size() + " URLs found in " + inputRowIndex));
            for (String url : urls) {
                StringCell urlCell = new StringCell(url);
                AppendedColumnRow row = new AppendedColumnRow(RowKey.createRowKey((long)outputRowIndex++), dataRow, new DataCell[]{urlCell});
                outputContainer.addRowToTable((DataRow)row);
            }
            exec.checkCanceled();
            exec.setProgress((double)inputRowIndex / (double)rowCount, "Adding row " + inputRowIndex);
        }
        outputContainer.close();
        BufferedDataTable out = outputContainer.getTable();
        return new BufferedDataTable[]{out};
    }

    private DataTableSpec getOutputSpec(DataTableSpec inputSpec) {
        DataColumnSpec[] resultSpec = new DataColumnSpec[inputSpec.getNumColumns() + 1];
        int index = 0;
        for (DataColumnSpec columnSpec : inputSpec) {
            resultSpec[index++] = columnSpec;
        }
        resultSpec[index] = new DataColumnSpecCreator("Extracted URL", StringCell.TYPE).createSpec();
        return new DataTableSpec(resultSpec);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingTextColumn.getStringValue(), StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingTextColumn.setStringValue(columnName);
        }
        DataTableSpec outputSpec = this.getOutputSpec(inSpec);
        return new DataTableSpec[]{outputSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingTextColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingTextColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingTextColumn.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

