/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.url;

import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.helper.collection.CollectionHelper;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.url.UrlResolverNodeDialog;
import ws.palladian.retrieval.HttpException;
import ws.palladian.retrieval.HttpRetriever;
import ws.palladian.retrieval.HttpRetrieverFactory;

public class UrlResolverNodeModel
extends SimpleStreamableFunctionNodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(UrlResolverNodeModel.class);
    static final String CFGKEY_TEXT_COLUMN = "urlColumn";
    private final HttpRetriever httpRetriever = HttpRetrieverFactory.getHttpRetriever();
    private final SettingsModelString settingUrlColumnName = UrlResolverNodeDialog.createSettingsUrlColumnName();

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        DataColumnSpec resolvedUrlSpec = new DataColumnSpecCreator("Resolved URL", StringCell.TYPE).createSpec();
        final int urlColumnIndex = spec.findColumnIndex(this.settingUrlColumnName.getStringValue());
        SingleCellFactory factory = new SingleCellFactory(resolvedUrlSpec){

            public DataCell getCell(DataRow row) {
                List redirectUrls;
                DataCell urlCell = row.getCell(urlColumnIndex);
                if (urlCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                String url = ((StringValue)urlCell).getStringValue();
                logger.debug((Object)("processing " + url));
                String redirectedUrl = url;
                try {
                    redirectUrls = UrlResolverNodeModel.this.httpRetriever.getRedirectUrls(url);
                }
                catch (HttpException e) {
                    logger.warn((Object)("Error for \"" + url + "\": " + e.getMessage()));
                    return DataType.getMissingCell();
                }
                catch (Exception e) {
                    logger.error((Object)("Error for \"" + url + "\": " + e.getMessage()));
                    return DataType.getMissingCell();
                }
                if (redirectUrls.size() > 0) {
                    redirectedUrl = (String)CollectionHelper.getLast((List)redirectUrls);
                }
                return new StringCell(redirectedUrl);
            }
        };
        factory.setParallelProcessing(true, 10, 50);
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingUrlColumnName.getStringValue(), StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingUrlColumnName.setStringValue(columnName);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingUrlColumnName.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingUrlColumnName.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingUrlColumnName.validateSettings(settings);
    }
}

