/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelColumnFilter2;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.RejectInputFilter;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.HttpRetrieverCellFactory;
import ws.palladian.retrieval.CookieStore;
import ws.palladian.retrieval.HttpRetriever;

public final class HttpRetrieverNodeSettings {
    private static final String CFGKEY_MAX_FILE_SIZE_ENABLED = "enableMaximumFileSize";
    private static final String CFGKEY_MAX_FILE_SIZE = "maximumFileSize";
    private static final String CFGKEY_URL_COLUMN_NAME = "urlColumn";
    private static final String CFGKEY_NUM_RETRIES = "numRetries";
    private static final String CFGKEY_CONNECTION_TIMEOUT = "connectionTimeout";
    private static final String CFGKEY_SOCKET_TIMEOUT = "socketTimeout";
    private static final String CFGKEY_USER_AGENT = "userAgent";
    private static final String CFGKEY_ADD_STATUS_CODE = "statusCodeColumn";
    private static final String CFGKEY_METHOD_COLUMN_NAME = "methodColumn";
    private static final String CFGKEY_ENTITY_COLUMN_NAME = "entityColumn";
    private static final String CFGKEY_ENTITY_CONTENT_TYPE = "entityContentType";
    private static final String CFGKEY_HEADER_COLUMN_SELECTION = "headerColumns";
    private static final String CFGKEY_ACCEPT_ALL_CERTS = "acceptAllCertificates";
    private static final String CFGKEY_FAIL_ON_NON_SUCCESS_HTTP_STATUS = "failOnNonSuccessHttpStatus";
    private static final String CFGKEY_FAIL_ON_NETWORK_ERROR = "failOnNetworkError";
    private static final String CFGKEY_USE_PROXY = "useCustomProxy";
    private static final String CFGKEY_PROXY_HOST = "proxyHost";
    private static final String CFGKEY_PROXY_PORT = "proxyPort";
    private static final String CFGKEY_PROXY_USERNAME = "proxyUsername";
    private static final String CFGKEY_PROXY_PASSWORD = "proxyPassword";
    private static final boolean DEFAULT_MAX_FILE_SIZE_ENABLED = false;
    private static final int DEFAULT_MAX_FILE_SIZE = 1024;
    public static final List<String> ENTITY_CONTENT_TYPES = Arrays.asList("application/x-www-form-urlencoded", "application/json", "text/plain");
    private static final String DEFAULT_ENTITY_CONTENT_TYPE = ENTITY_CONTENT_TYPES.get(0);
    final SettingsModelBoolean sizeLimit = new SettingsModelBoolean("enableMaximumFileSize", false);
    final SettingsModelInteger maxSize = new SettingsModelIntegerBounded("maximumFileSize", 1024, 0, Integer.MAX_VALUE);
    final SettingsModelString urlColumnName = new SettingsModelString("urlColumn", null);
    final SettingsModelInteger numRetries = new SettingsModelIntegerBounded("numRetries", 1, 0, 10);
    final SettingsModelInteger socketTimeout = new SettingsModelIntegerBounded("socketTimeout", HttpRetriever.DEFAULT_SOCKET_TIMEOUT, 0, Integer.MAX_VALUE);
    final SettingsModelInteger connectionTimeout = new SettingsModelIntegerBounded("connectionTimeout", HttpRetriever.DEFAULT_CONNECTION_TIMEOUT, 0, Integer.MAX_VALUE);
    final SettingsModelString userAgent = new SettingsModelString("userAgent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36");
    final SettingsModelBoolean addStatusCode = new SettingsModelBoolean("statusCodeColumn", false);
    final SettingsModelString methodColumnName = new SettingsModelString("methodColumn", null);
    final SettingsModelString entityColumnName = new SettingsModelString("entityColumn", null);
    final SettingsModelString entityContentType = new SettingsModelString("entityContentType", DEFAULT_ENTITY_CONTENT_TYPE);
    SettingsModelColumnFilter2 headerColumns;
    final SettingsModelBoolean acceptAllCerts = new SettingsModelBoolean("acceptAllCertificates", false);
    final SettingsModelBoolean failOnNonSuccessStatusCode = new SettingsModelBoolean("failOnNonSuccessHttpStatus", false);
    final SettingsModelBoolean failOnNetworkError = new SettingsModelBoolean("failOnNetworkError", false);
    final SettingsModelBoolean useCustomProxy = new SettingsModelBoolean("useCustomProxy", false);
    final SettingsModelString proxyHost = new SettingsModelString("proxyHost", null);
    final SettingsModelIntegerBounded proxyPort = new SettingsModelIntegerBounded("proxyPort", 0, 0, 65535);
    final SettingsModelString proxyUsername = new SettingsModelString("proxyUsername", null);
    final SettingsModelString proxyPassword = new SettingsModelString("proxyPassword", null);

    private static SettingsModelColumnFilter2 createSettingsHeaderColumns() {
        return new SettingsModelColumnFilter2(CFGKEY_HEADER_COLUMN_SELECTION, new Class[]{StringValue.class});
    }

    public HttpRetrieverNodeSettings() {
        this.enableFileSize();
        this.sizeLimit.addChangeListener(e -> this.enableFileSize());
        this.enableEntityContentType();
        this.entityColumnName.addChangeListener(e -> this.enableEntityContentType());
        this.useCustomProxy.addChangeListener(e -> this.enableProxySettings());
        this.enableProxySettings();
    }

    private void enableFileSize() {
        this.maxSize.setEnabled(this.sizeLimit.getBooleanValue());
    }

    private void enableEntityContentType() {
        this.entityContentType.setEnabled(this.entityColumnName.getStringValue() != null);
    }

    private void enableProxySettings() {
        boolean enabled = this.useCustomProxy.getBooleanValue();
        this.proxyHost.setEnabled(enabled);
        this.proxyPort.setEnabled(enabled);
        this.proxyUsername.setEnabled(enabled);
        this.proxyPassword.setEnabled(enabled);
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.sizeLimit.saveSettingsTo(settings);
        this.maxSize.saveSettingsTo(settings);
        this.urlColumnName.saveSettingsTo(settings);
        this.numRetries.saveSettingsTo(settings);
        this.connectionTimeout.saveSettingsTo(settings);
        this.socketTimeout.saveSettingsTo(settings);
        this.userAgent.saveSettingsTo(settings);
        this.addStatusCode.saveSettingsTo(settings);
        this.methodColumnName.saveSettingsTo(settings);
        this.entityColumnName.saveSettingsTo(settings);
        if (this.headerColumns != null) {
            this.headerColumns.saveSettingsTo(settings);
        }
        this.entityContentType.saveSettingsTo(settings);
        this.acceptAllCerts.saveSettingsTo(settings);
        this.failOnNonSuccessStatusCode.saveSettingsTo(settings);
        this.failOnNetworkError.saveSettingsTo(settings);
        this.useCustomProxy.saveSettingsTo(settings);
        this.proxyHost.saveSettingsTo(settings);
        this.proxyPort.saveSettingsTo(settings);
        this.proxyUsername.saveSettingsTo(settings);
        this.proxyPassword.saveSettingsTo(settings);
    }

    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.sizeLimit.loadSettingsFrom(settings);
        this.maxSize.loadSettingsFrom(settings);
        this.urlColumnName.loadSettingsFrom(settings);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.numRetries);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.connectionTimeout);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.socketTimeout);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.userAgent);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.addStatusCode);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.methodColumnName);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.entityColumnName);
        if (this.headerColumns == null) {
            this.headerColumns = HttpRetrieverNodeSettings.createSettingsHeaderColumns();
        }
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.headerColumns);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.entityContentType);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.acceptAllCerts);
        this.enableEntityContentType();
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.failOnNonSuccessStatusCode);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.failOnNetworkError);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.useCustomProxy);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.proxyHost);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.proxyPort);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.proxyUsername);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.proxyPassword);
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.sizeLimit.validateSettings(settings);
        this.maxSize.validateSettings(settings);
        this.urlColumnName.validateSettings(settings);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.numRetries);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.connectionTimeout);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.socketTimeout);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.userAgent);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.addStatusCode);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.methodColumnName);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.entityColumnName);
        SettingsModelColumnFilter2 filter = this.headerColumns == null ? HttpRetrieverNodeSettings.createSettingsHeaderColumns() : this.headerColumns;
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)filter);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.entityContentType);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.acceptAllCerts);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.failOnNonSuccessStatusCode);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.failOnNetworkError);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.useCustomProxy);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.proxyHost);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.proxyPort);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.proxyUsername);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.proxyPassword);
    }

    @Deprecated
    public HttpRetrieverCellFactory createCellFactory(DataTableSpec dataTableSpec, CookieStore cookieStore) {
        if (dataTableSpec == null) {
            throw new NullPointerException("dataTableSpec was null");
        }
        return new HttpRetrieverCellFactory(dataTableSpec, cookieStore, this);
    }

    public void configHeaderFilter(DataTableSpec urlInSpec) {
        if (this.headerColumns == null) {
            this.headerColumns = HttpRetrieverNodeSettings.createSettingsHeaderColumns();
            this.headerColumns.loadDefaults(urlInSpec, RejectInputFilter.INSTANCE, true);
        }
    }

    public SettingsModelColumnFilter2 getHeaderFilter() {
        return this.headerColumns == null ? HttpRetrieverNodeSettings.createSettingsHeaderColumns() : this.headerColumns;
    }
}

