/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.util.Collection;
import java.util.HashSet;
import ws.palladian.retrieval.Cookie;
import ws.palladian.retrieval.CookieStore;
import ws.palladian.retrieval.DefaultCookieStore;

public class ThreadSafeCookieStore
implements CookieStore {
    private final CookieStore cookieStore;

    public ThreadSafeCookieStore(CookieStore cookieStore) {
        if (cookieStore == null) {
            throw new NullPointerException("cookieStore was null");
        }
        this.cookieStore = cookieStore;
    }

    public ThreadSafeCookieStore() {
        this((CookieStore)new DefaultCookieStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Cookie> getCookies() {
        CookieStore cookieStore = this.cookieStore;
        synchronized (cookieStore) {
            return new HashSet<Cookie>(this.cookieStore.getCookies());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        CookieStore cookieStore = this.cookieStore;
        synchronized (cookieStore) {
            this.cookieStore.addCookie(cookie);
        }
    }

    public String toString() {
        return "ThreadSafeCookieStore [" + String.valueOf(this.getCookies()) + "]";
    }
}

